package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.Connection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceClassName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap
 *
 */
public class CcapBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap> {

    private AmId _amId;
    private java.lang.String _ccapId;
    private Connection _connection;
    private List<ServiceClassName> _downstreamScns;
    private List<java.lang.String> _error;
    private CcapKey _key;
    private List<IpPrefix> _subscriberSubnets;
    private List<ServiceClassName> _upstreamScns;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> augmentation = Collections.emptyMap();

    public CcapBuilder() {
    }
    public CcapBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes arg) {
        this._connection = arg.getConnection();
        this._amId = arg.getAmId();
        this._subscriberSubnets = arg.getSubscriberSubnets();
        this._upstreamScns = arg.getUpstreamScns();
        this._downstreamScns = arg.getDownstreamScns();
        this._error = arg.getError();
    }

    public CcapBuilder(Ccap base) {
        if (base.getKey() == null) {
            this._key = new CcapKey(
                base.getCcapId()
            );
            this._ccapId = base.getCcapId();
        } else {
            this._key = base.getKey();
            this._ccapId = _key.getCcapId();
        }
        this._amId = base.getAmId();
        this._connection = base.getConnection();
        this._downstreamScns = base.getDownstreamScns();
        this._error = base.getError();
        this._subscriberSubnets = base.getSubscriberSubnets();
        this._upstreamScns = base.getUpstreamScns();
        if (base instanceof CcapImpl) {
            CcapImpl impl = (CcapImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes) {
            this._connection = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes)arg).getConnection();
            this._amId = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes)arg).getAmId();
            this._subscriberSubnets = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes)arg).getSubscriberSubnets();
            this._upstreamScns = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes)arg).getUpstreamScns();
            this._downstreamScns = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes)arg).getDownstreamScns();
            this._error = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes)arg).getError();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public AmId getAmId() {
        return _amId;
    }
    
    public java.lang.String getCcapId() {
        return _ccapId;
    }
    
    public Connection getConnection() {
        return _connection;
    }
    
    public List<ServiceClassName> getDownstreamScns() {
        return _downstreamScns;
    }
    
    public List<java.lang.String> getError() {
        return _error;
    }
    
    public CcapKey getKey() {
        return _key;
    }
    
    public List<IpPrefix> getSubscriberSubnets() {
        return _subscriberSubnets;
    }
    
    public List<ServiceClassName> getUpstreamScns() {
        return _upstreamScns;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public CcapBuilder setAmId(final AmId value) {
        this._amId = value;
        return this;
    }
    
     
    public CcapBuilder setCcapId(final java.lang.String value) {
        this._ccapId = value;
        return this;
    }
    
     
    public CcapBuilder setConnection(final Connection value) {
        this._connection = value;
        return this;
    }
    
     
    public CcapBuilder setDownstreamScns(final List<ServiceClassName> value) {
        this._downstreamScns = value;
        return this;
    }
    
     
    public CcapBuilder setError(final List<java.lang.String> value) {
        this._error = value;
        return this;
    }
    
     
    public CcapBuilder setKey(final CcapKey value) {
        this._key = value;
        return this;
    }
    
     
    public CcapBuilder setSubscriberSubnets(final List<IpPrefix> value) {
        this._subscriberSubnets = value;
        return this;
    }
    
     
    public CcapBuilder setUpstreamScns(final List<ServiceClassName> value) {
        this._upstreamScns = value;
        return this;
    }
    
    public CcapBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public CcapBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ccap build() {
        return new CcapImpl(this);
    }

    private static final class CcapImpl implements Ccap {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap.class;
        }

        private final AmId _amId;
        private final java.lang.String _ccapId;
        private final Connection _connection;
        private final List<ServiceClassName> _downstreamScns;
        private final List<java.lang.String> _error;
        private final CcapKey _key;
        private final List<IpPrefix> _subscriberSubnets;
        private final List<ServiceClassName> _upstreamScns;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> augmentation = Collections.emptyMap();

        private CcapImpl(CcapBuilder base) {
            if (base.getKey() == null) {
                this._key = new CcapKey(
                    base.getCcapId()
                );
                this._ccapId = base.getCcapId();
            } else {
                this._key = base.getKey();
                this._ccapId = _key.getCcapId();
            }
            this._amId = base.getAmId();
            this._connection = base.getConnection();
            this._downstreamScns = base.getDownstreamScns();
            this._error = base.getError();
            this._subscriberSubnets = base.getSubscriberSubnets();
            this._upstreamScns = base.getUpstreamScns();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public AmId getAmId() {
            return _amId;
        }
        
        @Override
        public java.lang.String getCcapId() {
            return _ccapId;
        }
        
        @Override
        public Connection getConnection() {
            return _connection;
        }
        
        @Override
        public List<ServiceClassName> getDownstreamScns() {
            return _downstreamScns;
        }
        
        @Override
        public List<java.lang.String> getError() {
            return _error;
        }
        
        @Override
        public CcapKey getKey() {
            return _key;
        }
        
        @Override
        public List<IpPrefix> getSubscriberSubnets() {
            return _subscriberSubnets;
        }
        
        @Override
        public List<ServiceClassName> getUpstreamScns() {
            return _upstreamScns;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_amId);
            result = prime * result + Objects.hashCode(_ccapId);
            result = prime * result + Objects.hashCode(_connection);
            result = prime * result + Objects.hashCode(_downstreamScns);
            result = prime * result + Objects.hashCode(_error);
            result = prime * result + Objects.hashCode(_key);
            result = prime * result + Objects.hashCode(_subscriberSubnets);
            result = prime * result + Objects.hashCode(_upstreamScns);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap)obj;
            if (!Objects.equals(_amId, other.getAmId())) {
                return false;
            }
            if (!Objects.equals(_ccapId, other.getCcapId())) {
                return false;
            }
            if (!Objects.equals(_connection, other.getConnection())) {
                return false;
            }
            if (!Objects.equals(_downstreamScns, other.getDownstreamScns())) {
                return false;
            }
            if (!Objects.equals(_error, other.getError())) {
                return false;
            }
            if (!Objects.equals(_key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(_subscriberSubnets, other.getSubscriberSubnets())) {
                return false;
            }
            if (!Objects.equals(_upstreamScns, other.getUpstreamScns())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CcapImpl otherImpl = (CcapImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ccap [");
            boolean first = true;
        
            if (_amId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amId=");
                builder.append(_amId);
             }
            if (_ccapId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccapId=");
                builder.append(_ccapId);
             }
            if (_connection != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connection=");
                builder.append(_connection);
             }
            if (_downstreamScns != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_downstreamScns=");
                builder.append(_downstreamScns);
             }
            if (_error != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_error=");
                builder.append(_error);
             }
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (_subscriberSubnets != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subscriberSubnets=");
                builder.append(_subscriberSubnets);
             }
            if (_upstreamScns != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_upstreamScns=");
                builder.append(_upstreamScns);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
