package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Ccaps;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;


/**
 * CCAP devices are known by their network name which is any string. Each CCAP 
 * device has a network address:port, a list of subscriber IP subnets, and a list 
 * of available Service Class Names. 
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * list ccap {
 *     key "ccapId"
 *     leaf ccapId {
 *         type string;
 *     }
 *     container connection {
 *         leaf ipAddress {
 *             type ip-address;
 *         }
 *         leaf port {
 *             type port;
 *         }
 *         leaf connected {
 *             type boolean;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *         uses ccap-connection;
 *     }
 *     container amId {
 *         leaf am-tag {
 *             type uint16;
 *         }
 *         leaf am-type {
 *             type uint16;
 *         }
 *     }
 *     leaf-list subscriber-subnets {
 *         type ip-prefix;
 *     }
 *     leaf-list upstream-scns {
 *         type service-class-name;
 *     }
 *     leaf-list downstream-scns {
 *         type service-class-name;
 *     }
 *     leaf-list error {
 *         type string;
 *     }
 *     uses ccap-attributes;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccaps/ccap</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.CcapBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.CcapBuilder
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.CcapKey
 *
 */
public interface Ccap
    extends
    ChildOf<Ccaps>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap>,
    CcapAttributes,
    Identifiable<CcapKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ccap").intern();

    /**
     * CCAP Identity
     *
     *
     *
     * @return <code>java.lang.String</code> <code>ccapId</code>, or <code>null</code> if not present
     */
    java.lang.String getCcapId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.CcapKey</code> <code>key</code>, or <code>null</code> if not present
     */
    CcapKey getKey();

}

