package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.ccap;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.Ccap;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container connection {
 *     leaf ipAddress {
 *         type ip-address;
 *     }
 *     leaf port {
 *         type port;
 *     }
 *     leaf connected {
 *         type boolean;
 *     }
 *     leaf-list error {
 *         type string;
 *     }
 *     leaf timestamp {
 *         type date-and-time;
 *     }
 *     uses ccap-connection;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-set-connection/output/ccap/connection</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.ccap.ConnectionBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.ccap.ConnectionBuilder
 *
 */
public interface Connection
    extends
    ChildOf<Ccap>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.ccap.Connection>,
    CcapConnection
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "connection").intern();


}

