package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.ccap.Connection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapSetConnectionOutput;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container ccap {
 *     leaf ccapId {
 *         type string;
 *     }
 *     container connection {
 *         leaf ipAddress {
 *             type ip-address;
 *         }
 *         leaf port {
 *             type port;
 *         }
 *         leaf connected {
 *             type boolean;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *         uses ccap-connection;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-set-connection/output/ccap</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.CcapBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.CcapBuilder
 *
 */
public interface Ccap
    extends
    ChildOf<CcapSetConnectionOutput>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.Ccap>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ccap").intern();

    /**
     * @return <code>java.lang.String</code> <code>ccapId</code>, or <code>null</code> if not present
     */
    java.lang.String getCcapId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.output.ccap.Connection</code> <code>connection</code>, or <code>null</code> if not present
     */
    Connection getConnection();

}

