package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection
 *
 */
public class ConnectionBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection> {

    private java.lang.Boolean _connected;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> augmentation = Collections.emptyMap();

    public ConnectionBuilder() {
    }

    public ConnectionBuilder(Connection base) {
        this._connected = base.isConnected();
        if (base instanceof ConnectionImpl) {
            ConnectionImpl impl = (ConnectionImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Boolean isConnected() {
        return _connected;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ConnectionBuilder setConnected(final java.lang.Boolean value) {
        this._connected = value;
        return this;
    }
    
    public ConnectionBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ConnectionBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Connection build() {
        return new ConnectionImpl(this);
    }

    private static final class ConnectionImpl implements Connection {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection.class;
        }

        private final java.lang.Boolean _connected;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> augmentation = Collections.emptyMap();

        private ConnectionImpl(ConnectionBuilder base) {
            this._connected = base.isConnected();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Boolean isConnected() {
            return _connected;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_connected);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection)obj;
            if (!Objects.equals(_connected, other.isConnected())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ConnectionImpl otherImpl = (ConnectionImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Connection [");
            boolean first = true;
        
            if (_connected != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connected=");
                builder.append(_connected);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
