package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapSetConnectionInput;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container connection {
 *     leaf connected {
 *         type boolean;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-set-connection/input/connection</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.ConnectionBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.ConnectionBuilder
 *
 */
public interface Connection
    extends
    ChildOf<CcapSetConnectionInput>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "connection").intern();

    /**
     * COPS session state
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>connected</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isConnected();

}

