package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection
 *
 */
public class ConnectionBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection> {

    private List<java.lang.String> _error;
    private IpAddress _ipAddress;
    private PortNumber _port;
    private DateAndTime _timestamp;
    private java.lang.Boolean _connected;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> augmentation = Collections.emptyMap();

    public ConnectionBuilder() {
    }
    public ConnectionBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection arg) {
        this._ipAddress = arg.getIpAddress();
        this._port = arg.getPort();
        this._connected = arg.isConnected();
        this._error = arg.getError();
        this._timestamp = arg.getTimestamp();
    }

    public ConnectionBuilder(Connection base) {
        this._error = base.getError();
        this._ipAddress = base.getIpAddress();
        this._port = base.getPort();
        this._timestamp = base.getTimestamp();
        this._connected = base.isConnected();
        if (base instanceof ConnectionImpl) {
            ConnectionImpl impl = (ConnectionImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection) {
            this._ipAddress = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection)arg).getIpAddress();
            this._port = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection)arg).getPort();
            this._connected = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection)arg).isConnected();
            this._error = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection)arg).getError();
            this._timestamp = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection)arg).getTimestamp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapConnection] \n" +
              "but was: " + arg
            );
        }
    }

    public List<java.lang.String> getError() {
        return _error;
    }
    
    public IpAddress getIpAddress() {
        return _ipAddress;
    }
    
    public PortNumber getPort() {
        return _port;
    }
    
    public DateAndTime getTimestamp() {
        return _timestamp;
    }
    
    public java.lang.Boolean isConnected() {
        return _connected;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public ConnectionBuilder setError(final List<java.lang.String> value) {
        this._error = value;
        return this;
    }
    
     
    public ConnectionBuilder setIpAddress(final IpAddress value) {
        this._ipAddress = value;
        return this;
    }
    
     
    public ConnectionBuilder setPort(final PortNumber value) {
        this._port = value;
        return this;
    }
    
     
    public ConnectionBuilder setTimestamp(final DateAndTime value) {
        this._timestamp = value;
        return this;
    }
    
     
    public ConnectionBuilder setConnected(final java.lang.Boolean value) {
        this._connected = value;
        return this;
    }
    
    public ConnectionBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ConnectionBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Connection build() {
        return new ConnectionImpl(this);
    }

    private static final class ConnectionImpl implements Connection {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection.class;
        }

        private final List<java.lang.String> _error;
        private final IpAddress _ipAddress;
        private final PortNumber _port;
        private final DateAndTime _timestamp;
        private final java.lang.Boolean _connected;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> augmentation = Collections.emptyMap();

        private ConnectionImpl(ConnectionBuilder base) {
            this._error = base.getError();
            this._ipAddress = base.getIpAddress();
            this._port = base.getPort();
            this._timestamp = base.getTimestamp();
            this._connected = base.isConnected();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public List<java.lang.String> getError() {
            return _error;
        }
        
        @Override
        public IpAddress getIpAddress() {
            return _ipAddress;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @Override
        public DateAndTime getTimestamp() {
            return _timestamp;
        }
        
        @Override
        public java.lang.Boolean isConnected() {
            return _connected;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_error);
            result = prime * result + Objects.hashCode(_ipAddress);
            result = prime * result + Objects.hashCode(_port);
            result = prime * result + Objects.hashCode(_timestamp);
            result = prime * result + Objects.hashCode(_connected);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection)obj;
            if (!Objects.equals(_error, other.getError())) {
                return false;
            }
            if (!Objects.equals(_ipAddress, other.getIpAddress())) {
                return false;
            }
            if (!Objects.equals(_port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(_timestamp, other.getTimestamp())) {
                return false;
            }
            if (!Objects.equals(_connected, other.isConnected())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ConnectionImpl otherImpl = (ConnectionImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Connection [");
            boolean first = true;
        
            if (_error != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_error=");
                builder.append(_error);
             }
            if (_ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(_ipAddress);
             }
            if (_port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(_port);
             }
            if (_timestamp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_timestamp=");
                builder.append(_timestamp);
             }
            if (_connected != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connected=");
                builder.append(_connected);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
