package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.ccap.Connection;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap
 *
 */
public class CcapBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap> {

    private java.lang.String _ccapId;
    private Connection _connection;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> augmentation = Collections.emptyMap();

    public CcapBuilder() {
    }

    public CcapBuilder(Ccap base) {
        this._ccapId = base.getCcapId();
        this._connection = base.getConnection();
        if (base instanceof CcapImpl) {
            CcapImpl impl = (CcapImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.String getCcapId() {
        return _ccapId;
    }
    
    public Connection getConnection() {
        return _connection;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public CcapBuilder setCcapId(final java.lang.String value) {
        this._ccapId = value;
        return this;
    }
    
     
    public CcapBuilder setConnection(final Connection value) {
        this._connection = value;
        return this;
    }
    
    public CcapBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public CcapBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ccap build() {
        return new CcapImpl(this);
    }

    private static final class CcapImpl implements Ccap {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap.class;
        }

        private final java.lang.String _ccapId;
        private final Connection _connection;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> augmentation = Collections.emptyMap();

        private CcapImpl(CcapBuilder base) {
            this._ccapId = base.getCcapId();
            this._connection = base.getConnection();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getCcapId() {
            return _ccapId;
        }
        
        @Override
        public Connection getConnection() {
            return _connection;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ccapId);
            result = prime * result + Objects.hashCode(_connection);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap)obj;
            if (!Objects.equals(_ccapId, other.getCcapId())) {
                return false;
            }
            if (!Objects.equals(_connection, other.getConnection())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CcapImpl otherImpl = (CcapImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ccap [");
            boolean first = true;
        
            if (_ccapId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccapId=");
                builder.append(_ccapId);
             }
            if (_connection != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_connection=");
                builder.append(_connection);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
