package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId
 *
 */
public class AmIdBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId> {

    private java.lang.Integer _amTag;
    private java.lang.Integer _amType;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> augmentation = Collections.emptyMap();

    public AmIdBuilder() {
    }

    public AmIdBuilder(AmId base) {
        this._amTag = base.getAmTag();
        this._amType = base.getAmType();
        if (base instanceof AmIdImpl) {
            AmIdImpl impl = (AmIdImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getAmTag() {
        return _amTag;
    }
    
    public java.lang.Integer getAmType() {
        return _amType;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkAmTagRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public AmIdBuilder setAmTag(final java.lang.Integer value) {
    if (value != null) {
        checkAmTagRange(value);
    }
        this._amTag = value;
        return this;
    }
    
     
     private static void checkAmTypeRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public AmIdBuilder setAmType(final java.lang.Integer value) {
    if (value != null) {
        checkAmTypeRange(value);
    }
        this._amType = value;
        return this;
    }
    
    public AmIdBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public AmIdBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public AmId build() {
        return new AmIdImpl(this);
    }

    private static final class AmIdImpl implements AmId {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId.class;
        }

        private final java.lang.Integer _amTag;
        private final java.lang.Integer _amType;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> augmentation = Collections.emptyMap();

        private AmIdImpl(AmIdBuilder base) {
            this._amTag = base.getAmTag();
            this._amType = base.getAmType();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getAmTag() {
            return _amTag;
        }
        
        @Override
        public java.lang.Integer getAmType() {
            return _amType;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_amTag);
            result = prime * result + Objects.hashCode(_amType);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId)obj;
            if (!Objects.equals(_amTag, other.getAmTag())) {
                return false;
            }
            if (!Objects.equals(_amType, other.getAmType())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AmIdImpl otherImpl = (AmIdImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("AmId [");
            boolean first = true;
        
            if (_amTag != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amTag=");
                builder.append(_amTag);
             }
            if (_amType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_amType=");
                builder.append(_amType);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
