package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container amId {
 *     leaf am-tag {
 *         type uint16;
 *     }
 *     leaf am-type {
 *         type uint16;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-attributes/amId</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmIdBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmIdBuilder
 *
 */
public interface AmId
    extends
    ChildOf<CcapAttributes>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "amId").intern();

    /**
     * Application Manager Tag -- unique for this operator
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>amTag</code>, or <code>null</code> if not present
     */
    java.lang.Integer getAmTag();
    
    /**
     * Application Manager Type -- unique for this AM tag
     *
     *
     *
     * @return <code>java.lang.Integer</code> <code>amType</code>, or <code>null</code> if not present
     */
    java.lang.Integer getAmType();

}

