package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping tp-port-match-ranges {
 *     leaf srcPort-start {
 *         type port-number;
 *     }
 *     leaf srcPort-end {
 *         type port-number;
 *     }
 *     leaf dstPort-start {
 *         type port-number;
 *     }
 *     leaf dstPort-end {
 *         type port-number;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/tp-port-match-ranges</i>
 *
 */
public interface TpPortMatchRanges
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "tp-port-match-ranges").intern();

    /**
     * TCP/UDP source port range start.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>srcPortStart</code>, or <code>null</code> if not present
     */
    PortNumber getSrcPortStart();
    
    /**
     * TCP/UDP source port range end.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>srcPortEnd</code>, or <code>null</code> if not present
     */
    PortNumber getSrcPortEnd();
    
    /**
     * TCP/UDP destination port range start.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>dstPortStart</code>, or <code>null</code> if not present
     */
    PortNumber getDstPortStart();
    
    /**
     * TCP/UDP destination port range end.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>dstPortEnd</code>, or <code>null</code> if not present
     */
    PortNumber getDstPortEnd();

}

