package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;


public enum ServiceFlowDirection {
    /**
     * Upstream service flow.
     *
     */
    Us(1, "us"),
    
    /**
     * Downstream service flow.
     *
     */
    Ds(2, "ds")
    ;


    java.lang.String name;
    int value;
    private static final java.util.Map<java.lang.Integer, ServiceFlowDirection> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ServiceFlowDirection> b = com.google.common.collect.ImmutableMap.builder();
        for (ServiceFlowDirection enumItem : ServiceFlowDirection.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private ServiceFlowDirection(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding ServiceFlowDirection item
     */
    public static ServiceFlowDirection forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
