package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import com.google.common.base.Preconditions;
import java.util.Objects;


/**
 * The Service Class Name is MUST be 2-16 bytes.
 *
 */
public class ServiceClassName
 implements Serializable {
    private static final long serialVersionUID = 1494981434703549975L;
    private final java.lang.String _value;

    private static void check_valueLength(final String value) {
        final int length = value.length();
        if (length >= 2 && length <= 16) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[2‥16]].", value));
    }

    @ConstructorProperties("value")
    public ServiceClassName(java.lang.String _value) {
        if (_value != null) {
            check_valueLength(_value);
            }
    
    
        Preconditions.checkNotNull(_value, "Supplied value may not be null");
    
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ServiceClassName(ServiceClassName source) {
        this._value = source._value;
    }

    public static ServiceClassName getDefaultInstance(String defaultValue) {
        return new ServiceClassName(defaultValue);
    }

    public java.lang.String getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(_value);
        return result;
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        ServiceClassName other = (ServiceClassName) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public java.lang.String toString() {
        java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ServiceClassName.class.getSimpleName()).append(" [");
        boolean first = true;
    
        if (_value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(_value);
         }
        return builder.append(']').toString();
    }
}

