package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput
 *
 */
public class QosPollGatesOutputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput> {

    private Gate _gate;
    private java.lang.String _response;
    private DateAndTime _timestamp;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> augmentation = Collections.emptyMap();

    public QosPollGatesOutputBuilder() {
    }

    public QosPollGatesOutputBuilder(QosPollGatesOutput base) {
        this._gate = base.getGate();
        this._response = base.getResponse();
        this._timestamp = base.getTimestamp();
        if (base instanceof QosPollGatesOutputImpl) {
            QosPollGatesOutputImpl impl = (QosPollGatesOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Gate getGate() {
        return _gate;
    }
    
    public java.lang.String getResponse() {
        return _response;
    }
    
    public DateAndTime getTimestamp() {
        return _timestamp;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public QosPollGatesOutputBuilder setGate(final Gate value) {
        this._gate = value;
        return this;
    }
    
     
    public QosPollGatesOutputBuilder setResponse(final java.lang.String value) {
        this._response = value;
        return this;
    }
    
     
    public QosPollGatesOutputBuilder setTimestamp(final DateAndTime value) {
        this._timestamp = value;
        return this;
    }
    
    public QosPollGatesOutputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public QosPollGatesOutputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QosPollGatesOutput build() {
        return new QosPollGatesOutputImpl(this);
    }

    private static final class QosPollGatesOutputImpl implements QosPollGatesOutput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput.class;
        }

        private final Gate _gate;
        private final java.lang.String _response;
        private final DateAndTime _timestamp;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> augmentation = Collections.emptyMap();

        private QosPollGatesOutputImpl(QosPollGatesOutputBuilder base) {
            this._gate = base.getGate();
            this._response = base.getResponse();
            this._timestamp = base.getTimestamp();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Gate getGate() {
            return _gate;
        }
        
        @Override
        public java.lang.String getResponse() {
            return _response;
        }
        
        @Override
        public DateAndTime getTimestamp() {
            return _timestamp;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_gate);
            result = prime * result + Objects.hashCode(_response);
            result = prime * result + Objects.hashCode(_timestamp);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput)obj;
            if (!Objects.equals(_gate, other.getGate())) {
                return false;
            }
            if (!Objects.equals(_response, other.getResponse())) {
                return false;
            }
            if (!Objects.equals(_timestamp, other.getTimestamp())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                QosPollGatesOutputImpl otherImpl = (QosPollGatesOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("QosPollGatesOutput [");
            boolean first = true;
        
            if (_gate != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gate=");
                builder.append(_gate);
             }
            if (_response != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_response=");
                builder.append(_response);
             }
            if (_timestamp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_timestamp=");
                builder.append(_timestamp);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
