package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container output {
 *     container gate {
 *         leaf gatePath {
 *             type string;
 *         }
 *         leaf ccapId {
 *             type string;
 *         }
 *         leaf cops-gate-state {
 *             type string;
 *         }
 *         leaf cops-gate-time-info {
 *             type string;
 *         }
 *         leaf cops-gate-usage-info {
 *             type string;
 *         }
 *         leaf cops-gateId {
 *             type string;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *         uses gate-operational-attributes;
 *     }
 *     leaf response {
 *         type string;
 *     }
 *     leaf timestamp {
 *         type date-and-time;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/qos-poll-gates/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutputBuilder
 *
 */
public interface QosPollGatesOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "output").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.qos.poll.gates.output.Gate</code> <code>gate</code>, or <code>null</code> if not present
     */
    Gate getGate();
    
    /**
     * @return <code>java.lang.String</code> <code>response</code>, or <code>null</code> if not present
     */
    java.lang.String getResponse();
    
    /**
     * RPC timestamp
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>timestamp</code>, or <code>null</code> if not present
     */
    DateAndTime getTimestamp();

}

