package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput
 *
 */
public class QosPollGatesInputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput> {

    private InstanceIdentifier<?> _appId;
    private java.lang.String _gateId;
    private java.lang.String _subscriberId;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> augmentation = Collections.emptyMap();

    public QosPollGatesInputBuilder() {
    }

    public QosPollGatesInputBuilder(QosPollGatesInput base) {
        this._appId = base.getAppId();
        this._gateId = base.getGateId();
        this._subscriberId = base.getSubscriberId();
        if (base instanceof QosPollGatesInputImpl) {
            QosPollGatesInputImpl impl = (QosPollGatesInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public InstanceIdentifier<?> getAppId() {
        return _appId;
    }
    
    public java.lang.String getGateId() {
        return _gateId;
    }
    
    public java.lang.String getSubscriberId() {
        return _subscriberId;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public QosPollGatesInputBuilder setAppId(final InstanceIdentifier<?> value) {
        this._appId = value;
        return this;
    }
    
     
    public QosPollGatesInputBuilder setGateId(final java.lang.String value) {
        this._gateId = value;
        return this;
    }
    
     
    public QosPollGatesInputBuilder setSubscriberId(final java.lang.String value) {
        this._subscriberId = value;
        return this;
    }
    
    public QosPollGatesInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public QosPollGatesInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public QosPollGatesInput build() {
        return new QosPollGatesInputImpl(this);
    }

    private static final class QosPollGatesInputImpl implements QosPollGatesInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput.class;
        }

        private final InstanceIdentifier<?> _appId;
        private final java.lang.String _gateId;
        private final java.lang.String _subscriberId;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> augmentation = Collections.emptyMap();

        private QosPollGatesInputImpl(QosPollGatesInputBuilder base) {
            this._appId = base.getAppId();
            this._gateId = base.getGateId();
            this._subscriberId = base.getSubscriberId();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public InstanceIdentifier<?> getAppId() {
            return _appId;
        }
        
        @Override
        public java.lang.String getGateId() {
            return _gateId;
        }
        
        @Override
        public java.lang.String getSubscriberId() {
            return _subscriberId;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_appId);
            result = prime * result + Objects.hashCode(_gateId);
            result = prime * result + Objects.hashCode(_subscriberId);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput)obj;
            if (!Objects.equals(_appId, other.getAppId())) {
                return false;
            }
            if (!Objects.equals(_gateId, other.getGateId())) {
                return false;
            }
            if (!Objects.equals(_subscriberId, other.getSubscriberId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                QosPollGatesInputImpl otherImpl = (QosPollGatesInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("QosPollGatesInput [");
            boolean first = true;
        
            if (_appId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_appId=");
                builder.append(_appId);
             }
            if (_gateId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gateId=");
                builder.append(_gateId);
             }
            if (_subscriberId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subscriberId=");
                builder.append(_subscriberId);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
