package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container input {
 *     leaf appId {
 *         type instance-identifier;
 *     }
 *     leaf subscriberId {
 *         type string;
 *     }
 *     leaf gateId {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/qos-poll-gates/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInputBuilder
 *
 */
public interface QosPollGatesInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosPollGatesInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "input").intern();

    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>appId</code>, or <code>null</code> if not present
     */
    @RoutingContext
    (
    value=org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.AppContext.class
    )
    InstanceIdentifier<?> getAppId();
    
    /**
     * Subscriber Identity -- must be a CM or CPE IP address
     *
     *
     *
     * @return <code>java.lang.String</code> <code>subscriberId</code>, or <code>null</code> if not present
     */
    java.lang.String getSubscriberId();
    
    /**
     * Qos Gate Identity
     *
     *
     *
     * @return <code>java.lang.String</code> <code>gateId</code>, or <code>null</code> if not present
     */
    java.lang.String getGateId();

}

