package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gates.Apps;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos
 *
 */
public class QosBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos> {

    private Apps _apps;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> augmentation = Collections.emptyMap();

    public QosBuilder() {
    }
    public QosBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosGates arg) {
        this._apps = arg.getApps();
    }

    public QosBuilder(Qos base) {
        this._apps = base.getApps();
        if (base instanceof QosImpl) {
            QosImpl impl = (QosImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosGates</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosGates) {
            this._apps = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosGates)arg).getApps();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.PcmmQosGates] \n" +
              "but was: " + arg
            );
        }
    }

    public Apps getApps() {
        return _apps;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public QosBuilder setApps(final Apps value) {
        this._apps = value;
        return this;
    }
    
    public QosBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public QosBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Qos build() {
        return new QosImpl(this);
    }

    private static final class QosImpl implements Qos {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos.class;
        }

        private final Apps _apps;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> augmentation = Collections.emptyMap();

        private QosImpl(QosBuilder base) {
            this._apps = base.getApps();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Apps getApps() {
            return _apps;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_apps);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos)obj;
            if (!Objects.equals(_apps, other.getApps())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                QosImpl otherImpl = (QosImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Qos [");
            boolean first = true;
        
            if (_apps != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_apps=");
                builder.append(_apps);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
