package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * PCMM QoS Gates are organized as a tree by Application/Subscriber/Gate: Each 
 * Application is known by its appId which is any string. Each Subscriber is known 
 * by its subscriberId which is a CPE IP address in either IPv4 or IPv6 format. 
 * Each Gate is known by its gateId which is any string. The subscriber's CPE IP 
 * address is used to locate the CCAP device that is currently hosting the the 
 * Cable Modem that is connected to the subscriber's device. Therefore, it is not 
 * necessary for the PCMM applications to know the topology of the CCAP devices 
 * CMs in the network path to their subscriber devices. Note that each CCAP entry 
 * contains a list of connected subscriber IP subnets as well as a list of all 
 * Service Class Names (SCNs) available on the CCAP device. 
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container qos {
 *     container apps {
 *         list app {
 *             key "appId"
 *             leaf appId {
 *                 type string;
 *             }
 *             container subscribers {
 *                 list subscriber {
 *                     key "subscriberId"
 *                     leaf subscriberId {
 *                         type string;
 *                     }
 *                     container gates {
 *                         list gate {
 *                             key "gateId"
 *                             leaf gateId {
 *                                 type string;
 *                             }
 *                             leaf gatePath {
 *                                 type string;
 *                             }
 *                             leaf ccapId {
 *                                 type string;
 *                             }
 *                             leaf cops-gate-state {
 *                                 type string;
 *                             }
 *                             leaf cops-gate-time-info {
 *                                 type string;
 *                             }
 *                             leaf cops-gate-usage-info {
 *                                 type string;
 *                             }
 *                             leaf cops-gateId {
 *                                 type string;
 *                             }
 *                             leaf-list error {
 *                                 type string;
 *                             }
 *                             leaf timestamp {
 *                                 type date-and-time;
 *                             }
 *                             container traffic-profile {
 *                                 leaf service-class-name {
 *                                     type service-class-name;
 *                                 }
 *                             }
 *                             container gate-spec {
 *                                 leaf direction {
 *                                     type service-flow-direction;
 *                                 }
 *                                 leaf dscp-tos-overwrite {
 *                                     type tos-byte;
 *                                 }
 *                                 leaf dscp-tos-mask {
 *                                     type tos-byte;
 *                                 }
 *                             }
 *                             container classifiers {
 *                                 list classifier-container {
 *                                     key "classifier-id"
 *                                     leaf classifier-id {
 *                                         type uint8;
 *                                     }
 *                                     choice classifier-choice {
 *                                         case ext-classifier-choice {
 *                                             container ext-classifier {
 *                                                 leaf srcIp {
 *                                                     type ipv4-address;
 *                                                 }
 *                                                 leaf srcIpMask {
 *                                                     type ipv4-address;
 *                                                 }
 *                                                 leaf dstIp {
 *                                                     type ipv4-address;
 *                                                 }
 *                                                 leaf dstIpMask {
 *                                                     type ipv4-address;
 *                                                 }
 *                                                 leaf tos-byte {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf tos-mask {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf protocol {
 *                                                     type tp-protocol;
 *                                                 }
 *                                                 leaf srcPort-start {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf srcPort-end {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf dstPort-start {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf dstPort-end {
 *                                                     type port-number;
 *                                                 }
 *                                                 uses tp-port-match-ranges;
 *                                             }
 *                                         }
 *                                         case ipv6-classifier-choice {
 *                                             container ipv6-classifier {
 *                                                 leaf srcIp6 {
 *                                                     type ipv6-prefix;
 *                                                 }
 *                                                 leaf dstIp6 {
 *                                                     type ipv6-prefix;
 *                                                 }
 *                                                 leaf tc-low {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf tc-high {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf tc-mask {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf next-hdr {
 *                                                     type tp-protocol;
 *                                                 }
 *                                                 leaf flow-label {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf srcPort-start {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf srcPort-end {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf dstPort-start {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf dstPort-end {
 *                                                     type port-number;
 *                                                 }
 *                                                 uses tp-port-match-ranges;
 *                                             }
 *                                         }
 *                                         case qos-classifier-choice {
 *                                             container classifier {
 *                                                 leaf srcIp {
 *                                                     type ipv4-address;
 *                                                 }
 *                                                 leaf dstIp {
 *                                                     type ipv4-address;
 *                                                 }
 *                                                 leaf tos-byte {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf tos-mask {
 *                                                     type tos-byte;
 *                                                 }
 *                                                 leaf protocol {
 *                                                     type tp-protocol;
 *                                                 }
 *                                                 leaf srcPort {
 *                                                     type port-number;
 *                                                 }
 *                                                 leaf dstPort {
 *                                                     type port-number;
 *                                                 }
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                             }
 *                             uses pcmm-qos-gate-attributes;
 *                             uses gate-operational-attributes;
 *                         }
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     uses pcmm-qos-gates;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/qos</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.QosBuilder
 *
 */
public interface Qos
    extends
    ChildOf<PacketcableData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos>,
    PcmmQosGates
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "qos").intern();


}

