package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping pcmm-qos-traffic-profile {
 *     container traffic-profile {
 *         leaf service-class-name {
 *             type service-class-name;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-traffic-profile</i>
 *
 */
public interface PcmmQosTrafficProfile
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "pcmm-qos-traffic-profile").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.traffic.profile.TrafficProfile</code> <code>trafficProfile</code>, or <code>null</code> if not present
     */
    TrafficProfile getTrafficProfile();

}

