package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping pcmm-qos-ipv6-classifier {
 *     container ipv6-classifier {
 *         leaf srcIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf dstIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf tc-low {
 *             type tos-byte;
 *         }
 *         leaf tc-high {
 *             type tos-byte;
 *         }
 *         leaf tc-mask {
 *             type tos-byte;
 *         }
 *         leaf next-hdr {
 *             type tp-protocol;
 *         }
 *         leaf flow-label {
 *             type uint32;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-ipv6-classifier</i>
 *
 */
public interface PcmmQosIpv6Classifier
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "pcmm-qos-ipv6-classifier").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ipv6.classifier.Ipv6Classifier</code> <code>ipv6Classifier</code>, or <code>null</code> if not present
     */
    Ipv6Classifier getIpv6Classifier();

}

