package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec.GateSpec;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping pcmm-qos-gate-spec {
 *     container gate-spec {
 *         leaf direction {
 *             type service-flow-direction;
 *         }
 *         leaf dscp-tos-overwrite {
 *             type tos-byte;
 *         }
 *         leaf dscp-tos-mask {
 *             type tos-byte;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-gate-spec</i>
 *
 */
public interface PcmmQosGateSpec
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "pcmm-qos-gate-spec").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.gate.spec.GateSpec</code> <code>gateSpec</code>, or <code>null</code> if not present
     */
    GateSpec getGateSpec();

}

