package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping pcmm-qos-gate-attributes {
 *     container gate-spec {
 *         leaf direction {
 *             type service-flow-direction;
 *         }
 *         leaf dscp-tos-overwrite {
 *             type tos-byte;
 *         }
 *         leaf dscp-tos-mask {
 *             type tos-byte;
 *         }
 *     }
 *     container traffic-profile {
 *         leaf service-class-name {
 *             type service-class-name;
 *         }
 *     }
 *     container classifiers {
 *         list classifier-container {
 *             key "classifier-id"
 *             leaf classifier-id {
 *                 type uint8;
 *             }
 *             choice classifier-choice {
 *                 case ext-classifier-choice {
 *                     container ext-classifier {
 *                         leaf srcIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf srcIpMask {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIpMask {
 *                             type ipv4-address;
 *                         }
 *                         leaf tos-byte {
 *                             type tos-byte;
 *                         }
 *                         leaf tos-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf protocol {
 *                             type tp-protocol;
 *                         }
 *                         leaf srcPort-start {
 *                             type port-number;
 *                         }
 *                         leaf srcPort-end {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-start {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-end {
 *                             type port-number;
 *                         }
 *                         uses tp-port-match-ranges;
 *                     }
 *                 }
 *                 case ipv6-classifier-choice {
 *                     container ipv6-classifier {
 *                         leaf srcIp6 {
 *                             type ipv6-prefix;
 *                         }
 *                         leaf dstIp6 {
 *                             type ipv6-prefix;
 *                         }
 *                         leaf tc-low {
 *                             type tos-byte;
 *                         }
 *                         leaf tc-high {
 *                             type tos-byte;
 *                         }
 *                         leaf tc-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf next-hdr {
 *                             type tp-protocol;
 *                         }
 *                         leaf flow-label {
 *                             type uint32;
 *                         }
 *                         leaf srcPort-start {
 *                             type port-number;
 *                         }
 *                         leaf srcPort-end {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-start {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-end {
 *                             type port-number;
 *                         }
 *                         uses tp-port-match-ranges;
 *                     }
 *                 }
 *                 case qos-classifier-choice {
 *                     container classifier {
 *                         leaf srcIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf tos-byte {
 *                             type tos-byte;
 *                         }
 *                         leaf tos-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf protocol {
 *                             type tp-protocol;
 *                         }
 *                         leaf srcPort {
 *                             type port-number;
 *                         }
 *                         leaf dstPort {
 *                             type port-number;
 *                         }
 *                     }
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-gate-attributes</i>
 *
 */
public interface PcmmQosGateAttributes
    extends
    DataObject,
    PcmmQosGateSpec,
    ClassifierAttributes,
    PcmmQosTrafficProfile
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "pcmm-qos-gate-attributes").intern();


}

