package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping pcmm-qos-ext-classifier {
 *     container ext-classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf srcIpMask {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIpMask {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-ext-classifier</i>
 *
 */
public interface PcmmQosExtClassifier
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "pcmm-qos-ext-classifier").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.ext.classifier.ExtClassifier</code> <code>extClassifier</code>, or <code>null</code> if not present
     */
    ExtClassifier getExtClassifier();

}

