package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping pcmm-qos-classifier {
 *     container classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort {
 *             type port-number;
 *         }
 *         leaf dstPort {
 *             type port-number;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/pcmm-qos-classifier</i>
 *
 */
public interface PcmmQosClassifier
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "pcmm-qos-classifier").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.pcmm.qos.classifier.Classifier</code> <code>classifier</code>, or <code>null</code> if not present
     */
    Classifier getClassifier();

}

