package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;


/**
 * Interface for implementing the following YANG RPCs defined in module <b>packetcable</b>
 * <pre>
 * rpc ccap-poll-connection {
 *     input {
 *         leaf ccapId {
 *             type instance-identifier;
 *         }
 *     }
 *     
 *     output {
 *         container ccap {
 *             leaf ccapId {
 *                 type string;
 *             }
 *             container connection {
 *                 leaf ipAddress {
 *                     type ip-address;
 *                 }
 *                 leaf port {
 *                     type port;
 *                 }
 *                 leaf connected {
 *                     type boolean;
 *                 }
 *                 leaf-list error {
 *                     type string;
 *                 }
 *                 leaf timestamp {
 *                     type date-and-time;
 *                 }
 *                 uses ccap-connection;
 *             }
 *         }
 *         leaf response {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *     }
 * }
 * rpc qos-poll-gates {
 *     input {
 *         leaf appId {
 *             type instance-identifier;
 *         }
 *         leaf subscriberId {
 *             type string;
 *         }
 *         leaf gateId {
 *             type string;
 *         }
 *     }
 *     
 *     output {
 *         container gate {
 *             leaf gatePath {
 *                 type string;
 *             }
 *             leaf ccapId {
 *                 type string;
 *             }
 *             leaf cops-gate-state {
 *                 type string;
 *             }
 *             leaf cops-gate-time-info {
 *                 type string;
 *             }
 *             leaf cops-gate-usage-info {
 *                 type string;
 *             }
 *             leaf cops-gateId {
 *                 type string;
 *             }
 *             leaf-list error {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *             uses gate-operational-attributes;
 *         }
 *         leaf response {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *     }
 * }
 * rpc ccap-set-connection {
 *     input {
 *         leaf ccapId {
 *             type instance-identifier;
 *         }
 *         container connection {
 *             leaf connected {
 *                 type boolean;
 *             }
 *         }
 *     }
 *     
 *     output {
 *         container ccap {
 *             leaf ccapId {
 *                 type string;
 *             }
 *             container connection {
 *                 leaf ipAddress {
 *                     type ip-address;
 *                 }
 *                 leaf port {
 *                     type port;
 *                 }
 *                 leaf connected {
 *                     type boolean;
 *                 }
 *                 leaf-list error {
 *                     type string;
 *                 }
 *                 leaf timestamp {
 *                     type date-and-time;
 *                 }
 *                 uses ccap-connection;
 *             }
 *         }
 *         leaf response {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface PacketcableService
    extends
    RpcService
{




    Future<RpcResult<CcapPollConnectionOutput>> ccapPollConnection(CcapPollConnectionInput input);
    
    Future<RpcResult<QosPollGatesOutput>> qosPollGates(QosPollGatesInput input);
    
    Future<RpcResult<CcapSetConnectionOutput>> ccapSetConnection(CcapSetConnectionInput input);

}

