package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * This module contains the PCMM Converged Cable Access Platform (CCAP) definitions
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * module packetcable {
 *     yang-version 1;
 *     namespace "urn:packetcable";
 *     prefix "pcmm";
 *
 *     import yang-ext { prefix "ext"; }
 *     
 *     import ietf-inet-types { prefix "inet"; }
 *     
 *     import ietf-yang-types { prefix "yang"; }
 *     revision 2015-11-01 {
 *         description "This module contains the PCMM Converged Cable Access Platform (CCAP) definitions
 *         ";
 *     }
 *
 *     container ccaps {
 *         list ccap {
 *             key "ccapId"
 *             leaf ccapId {
 *                 type string;
 *             }
 *             container connection {
 *                 leaf ipAddress {
 *                     type ip-address;
 *                 }
 *                 leaf port {
 *                     type port;
 *                 }
 *                 leaf connected {
 *                     type boolean;
 *                 }
 *                 leaf-list error {
 *                     type string;
 *                 }
 *                 leaf timestamp {
 *                     type date-and-time;
 *                 }
 *                 uses ccap-connection;
 *             }
 *             container amId {
 *                 leaf am-tag {
 *                     type uint16;
 *                 }
 *                 leaf am-type {
 *                     type uint16;
 *                 }
 *             }
 *             leaf-list subscriber-subnets {
 *                 type ip-prefix;
 *             }
 *             leaf-list upstream-scns {
 *                 type service-class-name;
 *             }
 *             leaf-list downstream-scns {
 *                 type service-class-name;
 *             }
 *             leaf-list error {
 *                 type string;
 *             }
 *             uses ccap-attributes;
 *         }
 *     }
 *     container qos {
 *         container apps {
 *             list app {
 *                 key "appId"
 *                 leaf appId {
 *                     type string;
 *                 }
 *                 container subscribers {
 *                     list subscriber {
 *                         key "subscriberId"
 *                         leaf subscriberId {
 *                             type string;
 *                         }
 *                         container gates {
 *                             list gate {
 *                                 key "gateId"
 *                                 leaf gateId {
 *                                     type string;
 *                                 }
 *                                 leaf gatePath {
 *                                     type string;
 *                                 }
 *                                 leaf ccapId {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gate-state {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gate-time-info {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gate-usage-info {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gateId {
 *                                     type string;
 *                                 }
 *                                 leaf-list error {
 *                                     type string;
 *                                 }
 *                                 leaf timestamp {
 *                                     type date-and-time;
 *                                 }
 *                                 container traffic-profile {
 *                                     leaf service-class-name {
 *                                         type service-class-name;
 *                                     }
 *                                 }
 *                                 container gate-spec {
 *                                     leaf direction {
 *                                         type service-flow-direction;
 *                                     }
 *                                     leaf dscp-tos-overwrite {
 *                                         type tos-byte;
 *                                     }
 *                                     leaf dscp-tos-mask {
 *                                         type tos-byte;
 *                                     }
 *                                 }
 *                                 container classifiers {
 *                                     list classifier-container {
 *                                         key "classifier-id"
 *                                         leaf classifier-id {
 *                                             type uint8;
 *                                         }
 *                                         choice classifier-choice {
 *                                             case ext-classifier-choice {
 *                                                 container ext-classifier {
 *                                                     leaf srcIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf srcIpMask {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf dstIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf dstIpMask {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf tos-byte {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tos-mask {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf protocol {
 *                                                         type tp-protocol;
 *                                                     }
 *                                                     leaf srcPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf srcPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     uses tp-port-match-ranges;
 *                                                 }
 *                                             }
 *                                             case ipv6-classifier-choice {
 *                                                 container ipv6-classifier {
 *                                                     leaf srcIp6 {
 *                                                         type ipv6-prefix;
 *                                                     }
 *                                                     leaf dstIp6 {
 *                                                         type ipv6-prefix;
 *                                                     }
 *                                                     leaf tc-low {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tc-high {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tc-mask {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf next-hdr {
 *                                                         type tp-protocol;
 *                                                     }
 *                                                     leaf flow-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf srcPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf srcPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     uses tp-port-match-ranges;
 *                                                 }
 *                                             }
 *                                             case qos-classifier-choice {
 *                                                 container classifier {
 *                                                     leaf srcIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf dstIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf tos-byte {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tos-mask {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf protocol {
 *                                                         type tp-protocol;
 *                                                     }
 *                                                     leaf srcPort {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort {
 *                                                         type port-number;
 *                                                     }
 *                                                 }
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 uses pcmm-qos-gate-attributes;
 *                                 uses gate-operational-attributes;
 *                             }
 *                         }
 *                     }
 *                 }
 *             }
 *         }
 *         uses pcmm-qos-gates;
 *     }
 *
 *     grouping ccap-connection {
 *         leaf ipAddress {
 *             type ip-address;
 *         }
 *         leaf port {
 *             type port;
 *         }
 *         leaf connected {
 *             type boolean;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *     }
 *     grouping pcmm-qos-gate-attributes {
 *         container gate-spec {
 *             leaf direction {
 *                 type service-flow-direction;
 *             }
 *             leaf dscp-tos-overwrite {
 *                 type tos-byte;
 *             }
 *             leaf dscp-tos-mask {
 *                 type tos-byte;
 *             }
 *         }
 *         container traffic-profile {
 *             leaf service-class-name {
 *                 type service-class-name;
 *             }
 *         }
 *         container classifiers {
 *             list classifier-container {
 *                 key "classifier-id"
 *                 leaf classifier-id {
 *                     type uint8;
 *                 }
 *                 choice classifier-choice {
 *                     case ext-classifier-choice {
 *                         container ext-classifier {
 *                             leaf srcIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf srcIpMask {
 *                                 type ipv4-address;
 *                             }
 *                             leaf dstIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf dstIpMask {
 *                                 type ipv4-address;
 *                             }
 *                             leaf tos-byte {
 *                                 type tos-byte;
 *                             }
 *                             leaf tos-mask {
 *                                 type tos-byte;
 *                             }
 *                             leaf protocol {
 *                                 type tp-protocol;
 *                             }
 *                             leaf srcPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf srcPort-end {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-end {
 *                                 type port-number;
 *                             }
 *                             uses tp-port-match-ranges;
 *                         }
 *                     }
 *                     case ipv6-classifier-choice {
 *                         container ipv6-classifier {
 *                             leaf srcIp6 {
 *                                 type ipv6-prefix;
 *                             }
 *                             leaf dstIp6 {
 *                                 type ipv6-prefix;
 *                             }
 *                             leaf tc-low {
 *                                 type tos-byte;
 *                             }
 *                             leaf tc-high {
 *                                 type tos-byte;
 *                             }
 *                             leaf tc-mask {
 *                                 type tos-byte;
 *                             }
 *                             leaf next-hdr {
 *                                 type tp-protocol;
 *                             }
 *                             leaf flow-label {
 *                                 type uint32;
 *                             }
 *                             leaf srcPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf srcPort-end {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-end {
 *                                 type port-number;
 *                             }
 *                             uses tp-port-match-ranges;
 *                         }
 *                     }
 *                     case qos-classifier-choice {
 *                         container classifier {
 *                             leaf srcIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf dstIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf tos-byte {
 *                                 type tos-byte;
 *                             }
 *                             leaf tos-mask {
 *                                 type tos-byte;
 *                             }
 *                             leaf protocol {
 *                                 type tp-protocol;
 *                             }
 *                             leaf srcPort {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     grouping ccap-attributes {
 *         container connection {
 *             leaf ipAddress {
 *                 type ip-address;
 *             }
 *             leaf port {
 *                 type port;
 *             }
 *             leaf connected {
 *                 type boolean;
 *             }
 *             leaf-list error {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *             uses ccap-connection;
 *         }
 *         container amId {
 *             leaf am-tag {
 *                 type uint16;
 *             }
 *             leaf am-type {
 *                 type uint16;
 *             }
 *         }
 *         leaf-list subscriber-subnets {
 *             type ip-prefix;
 *         }
 *         leaf-list upstream-scns {
 *             type service-class-name;
 *         }
 *         leaf-list downstream-scns {
 *             type service-class-name;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *     }
 *     grouping pcmm-qos-classifier {
 *         container classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort {
 *                 type port-number;
 *             }
 *             leaf dstPort {
 *                 type port-number;
 *             }
 *         }
 *     }
 *     grouping pcmm-qos-gates {
 *         container apps {
 *             list app {
 *                 key "appId"
 *                 leaf appId {
 *                     type string;
 *                 }
 *                 container subscribers {
 *                     list subscriber {
 *                         key "subscriberId"
 *                         leaf subscriberId {
 *                             type string;
 *                         }
 *                         container gates {
 *                             list gate {
 *                                 key "gateId"
 *                                 leaf gateId {
 *                                     type string;
 *                                 }
 *                                 leaf gatePath {
 *                                     type string;
 *                                 }
 *                                 leaf ccapId {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gate-state {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gate-time-info {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gate-usage-info {
 *                                     type string;
 *                                 }
 *                                 leaf cops-gateId {
 *                                     type string;
 *                                 }
 *                                 leaf-list error {
 *                                     type string;
 *                                 }
 *                                 leaf timestamp {
 *                                     type date-and-time;
 *                                 }
 *                                 container traffic-profile {
 *                                     leaf service-class-name {
 *                                         type service-class-name;
 *                                     }
 *                                 }
 *                                 container gate-spec {
 *                                     leaf direction {
 *                                         type service-flow-direction;
 *                                     }
 *                                     leaf dscp-tos-overwrite {
 *                                         type tos-byte;
 *                                     }
 *                                     leaf dscp-tos-mask {
 *                                         type tos-byte;
 *                                     }
 *                                 }
 *                                 container classifiers {
 *                                     list classifier-container {
 *                                         key "classifier-id"
 *                                         leaf classifier-id {
 *                                             type uint8;
 *                                         }
 *                                         choice classifier-choice {
 *                                             case ext-classifier-choice {
 *                                                 container ext-classifier {
 *                                                     leaf srcIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf srcIpMask {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf dstIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf dstIpMask {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf tos-byte {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tos-mask {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf protocol {
 *                                                         type tp-protocol;
 *                                                     }
 *                                                     leaf srcPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf srcPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     uses tp-port-match-ranges;
 *                                                 }
 *                                             }
 *                                             case ipv6-classifier-choice {
 *                                                 container ipv6-classifier {
 *                                                     leaf srcIp6 {
 *                                                         type ipv6-prefix;
 *                                                     }
 *                                                     leaf dstIp6 {
 *                                                         type ipv6-prefix;
 *                                                     }
 *                                                     leaf tc-low {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tc-high {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tc-mask {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf next-hdr {
 *                                                         type tp-protocol;
 *                                                     }
 *                                                     leaf flow-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf srcPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf srcPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-start {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort-end {
 *                                                         type port-number;
 *                                                     }
 *                                                     uses tp-port-match-ranges;
 *                                                 }
 *                                             }
 *                                             case qos-classifier-choice {
 *                                                 container classifier {
 *                                                     leaf srcIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf dstIp {
 *                                                         type ipv4-address;
 *                                                     }
 *                                                     leaf tos-byte {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf tos-mask {
 *                                                         type tos-byte;
 *                                                     }
 *                                                     leaf protocol {
 *                                                         type tp-protocol;
 *                                                     }
 *                                                     leaf srcPort {
 *                                                         type port-number;
 *                                                     }
 *                                                     leaf dstPort {
 *                                                         type port-number;
 *                                                     }
 *                                                 }
 *                                             }
 *                                         }
 *                                     }
 *                                 }
 *                                 uses pcmm-qos-gate-attributes;
 *                                 uses gate-operational-attributes;
 *                             }
 *                         }
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     grouping classifier-attributes {
 *         container classifiers {
 *             list classifier-container {
 *                 key "classifier-id"
 *                 leaf classifier-id {
 *                     type uint8;
 *                 }
 *                 choice classifier-choice {
 *                     case ext-classifier-choice {
 *                         container ext-classifier {
 *                             leaf srcIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf srcIpMask {
 *                                 type ipv4-address;
 *                             }
 *                             leaf dstIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf dstIpMask {
 *                                 type ipv4-address;
 *                             }
 *                             leaf tos-byte {
 *                                 type tos-byte;
 *                             }
 *                             leaf tos-mask {
 *                                 type tos-byte;
 *                             }
 *                             leaf protocol {
 *                                 type tp-protocol;
 *                             }
 *                             leaf srcPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf srcPort-end {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-end {
 *                                 type port-number;
 *                             }
 *                             uses tp-port-match-ranges;
 *                         }
 *                     }
 *                     case ipv6-classifier-choice {
 *                         container ipv6-classifier {
 *                             leaf srcIp6 {
 *                                 type ipv6-prefix;
 *                             }
 *                             leaf dstIp6 {
 *                                 type ipv6-prefix;
 *                             }
 *                             leaf tc-low {
 *                                 type tos-byte;
 *                             }
 *                             leaf tc-high {
 *                                 type tos-byte;
 *                             }
 *                             leaf tc-mask {
 *                                 type tos-byte;
 *                             }
 *                             leaf next-hdr {
 *                                 type tp-protocol;
 *                             }
 *                             leaf flow-label {
 *                                 type uint32;
 *                             }
 *                             leaf srcPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf srcPort-end {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-start {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort-end {
 *                                 type port-number;
 *                             }
 *                             uses tp-port-match-ranges;
 *                         }
 *                     }
 *                     case qos-classifier-choice {
 *                         container classifier {
 *                             leaf srcIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf dstIp {
 *                                 type ipv4-address;
 *                             }
 *                             leaf tos-byte {
 *                                 type tos-byte;
 *                             }
 *                             leaf tos-mask {
 *                                 type tos-byte;
 *                             }
 *                             leaf protocol {
 *                                 type tp-protocol;
 *                             }
 *                             leaf srcPort {
 *                                 type port-number;
 *                             }
 *                             leaf dstPort {
 *                                 type port-number;
 *                             }
 *                         }
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     grouping pcmm-qos-ipv6-classifier {
 *         container ipv6-classifier {
 *             leaf srcIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf dstIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf tc-low {
 *                 type tos-byte;
 *             }
 *             leaf tc-high {
 *                 type tos-byte;
 *             }
 *             leaf tc-mask {
 *                 type tos-byte;
 *             }
 *             leaf next-hdr {
 *                 type tp-protocol;
 *             }
 *             leaf flow-label {
 *                 type uint32;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *     }
 *     grouping pcmm-qos-traffic-profile {
 *         container traffic-profile {
 *             leaf service-class-name {
 *                 type service-class-name;
 *             }
 *         }
 *     }
 *     grouping tp-port-match-ranges {
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *     }
 *     grouping gate-operational-attributes {
 *         leaf gatePath {
 *             type string;
 *         }
 *         leaf ccapId {
 *             type string;
 *         }
 *         leaf cops-gate-state {
 *             type string;
 *         }
 *         leaf cops-gate-time-info {
 *             type string;
 *         }
 *         leaf cops-gate-usage-info {
 *             type string;
 *         }
 *         leaf cops-gateId {
 *             type string;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *     }
 *     grouping pcmm-qos-ext-classifier {
 *         container ext-classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf srcIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *     }
 *     grouping pcmm-qos-gate-spec {
 *         container gate-spec {
 *             leaf direction {
 *                 type service-flow-direction;
 *             }
 *             leaf dscp-tos-overwrite {
 *                 type tos-byte;
 *             }
 *             leaf dscp-tos-mask {
 *                 type tos-byte;
 *             }
 *         }
 *     }
 *
 *     identity app-context {
 *         description
 *             "Identity used to mark app context";
 *         status CURRENT;
 *     }
 *     identity ccap-context {
 *         description
 *             "Identity used to mark ccap context";
 *         status CURRENT;
 *     }
 *
 *     rpc ccap-poll-connection {
 *         input {
 *             leaf ccapId {
 *                 type instance-identifier;
 *             }
 *         }
 *         
 *         output {
 *             container ccap {
 *                 leaf ccapId {
 *                     type string;
 *                 }
 *                 container connection {
 *                     leaf ipAddress {
 *                         type ip-address;
 *                     }
 *                     leaf port {
 *                         type port;
 *                     }
 *                     leaf connected {
 *                         type boolean;
 *                     }
 *                     leaf-list error {
 *                         type string;
 *                     }
 *                     leaf timestamp {
 *                         type date-and-time;
 *                     }
 *                     uses ccap-connection;
 *                 }
 *             }
 *             leaf response {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *         }
 *     }
 *     rpc qos-poll-gates {
 *         input {
 *             leaf appId {
 *                 type instance-identifier;
 *             }
 *             leaf subscriberId {
 *                 type string;
 *             }
 *             leaf gateId {
 *                 type string;
 *             }
 *         }
 *         
 *         output {
 *             container gate {
 *                 leaf gatePath {
 *                     type string;
 *                 }
 *                 leaf ccapId {
 *                     type string;
 *                 }
 *                 leaf cops-gate-state {
 *                     type string;
 *                 }
 *                 leaf cops-gate-time-info {
 *                     type string;
 *                 }
 *                 leaf cops-gate-usage-info {
 *                     type string;
 *                 }
 *                 leaf cops-gateId {
 *                     type string;
 *                 }
 *                 leaf-list error {
 *                     type string;
 *                 }
 *                 leaf timestamp {
 *                     type date-and-time;
 *                 }
 *                 uses gate-operational-attributes;
 *             }
 *             leaf response {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *         }
 *     }
 *     rpc ccap-set-connection {
 *         input {
 *             leaf ccapId {
 *                 type instance-identifier;
 *             }
 *             container connection {
 *                 leaf connected {
 *                     type boolean;
 *                 }
 *             }
 *         }
 *         
 *         output {
 *             container ccap {
 *                 leaf ccapId {
 *                     type string;
 *                 }
 *                 container connection {
 *                     leaf ipAddress {
 *                         type ip-address;
 *                     }
 *                     leaf port {
 *                         type port;
 *                     }
 *                     leaf connected {
 *                         type boolean;
 *                     }
 *                     leaf-list error {
 *                         type string;
 *                     }
 *                     leaf timestamp {
 *                         type date-and-time;
 *                     }
 *                     uses ccap-connection;
 *                 }
 *             }
 *             leaf response {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface PacketcableData
    extends
    DataRoot
{




    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Ccaps</code> <code>ccaps</code>, or <code>null</code> if not present
     */
    Ccaps getCcaps();
    
    /**
     *  PCMM QoS Gates are organized as a tree by Application/Subscriber/Gate: Each 
     * Application is known by its appId which is any string. Each Subscriber is known 
     * by its subscriberId which is a CPE IP address in either IPv4 or IPv6 format. 
     * Each Gate is known by its gateId which is any string. The subscriber's CPE IP 
     * address is used to locate the CCAP device that is currently hosting the the 
     * Cable Modem that is connected to the subscriber's device. Therefore, it is not 
     * necessary for the PCMM applications to know the topology of the CCAP devices and
     * CMs in the network path to their subscriber devices. Note that each CCAP entry 
     * contains a list of connected subscriber IP subnets as well as a list of all 
     * Service Class Names (SCNs) available on the CCAP device. 
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Qos</code> <code>qos</code>, or <code>null</code> if not present
     */
    Qos getQos();

}

