package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import java.util.List;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping gate-operational-attributes {
 *     leaf gatePath {
 *         type string;
 *     }
 *     leaf ccapId {
 *         type string;
 *     }
 *     leaf cops-gate-state {
 *         type string;
 *     }
 *     leaf cops-gate-time-info {
 *         type string;
 *     }
 *     leaf cops-gate-usage-info {
 *         type string;
 *     }
 *     leaf cops-gateId {
 *         type string;
 *     }
 *     leaf-list error {
 *         type string;
 *     }
 *     leaf timestamp {
 *         type date-and-time;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/gate-operational-attributes</i>
 *
 */
public interface GateOperationalAttributes
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "gate-operational-attributes").intern();

    /**
     * FQ Gate path app/subscriber/gate
     *
     *
     *
     * @return <code>java.lang.String</code> <code>gatePath</code>, or <code>null</code> if not present
     */
    java.lang.String getGatePath();
    
    /**
     * CCAP Identity
     *
     *
     *
     * @return <code>java.lang.String</code> <code>ccapId</code>, or <code>null</code> if not present
     */
    java.lang.String getCcapId();
    
    /**
     * Operational COPS Gate state
     *
     *
     *
     * @return <code>java.lang.String</code> <code>copsGateState</code>, or <code>null</code> if not present
     */
    java.lang.String getCopsGateState();
    
    /**
     * Operational COPS Gate time info
     *
     *
     *
     * @return <code>java.lang.String</code> <code>copsGateTimeInfo</code>, or <code>null</code> if not present
     */
    java.lang.String getCopsGateTimeInfo();
    
    /**
     * Operational COPS gate usage info
     *
     *
     *
     * @return <code>java.lang.String</code> <code>copsGateUsageInfo</code>, or <code>null</code> if not present
     */
    java.lang.String getCopsGateUsageInfo();
    
    /**
     * Gate operational COPS Id
     *
     *
     *
     * @return <code>java.lang.String</code> <code>copsGateId</code>, or <code>null</code> if not present
     */
    java.lang.String getCopsGateId();
    
    /**
     * Gate operational error
     *
     *
     *
     * @return <code>java.util.List</code> <code>error</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getError();
    
    /**
     * Gate operational attributes timestamp
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>timestamp</code>, or <code>null</code> if not present
     */
    DateAndTime getTimestamp();

}

