package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccaps.Ccap;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container ccaps {
 *     list ccap {
 *         key "ccapId"
 *         leaf ccapId {
 *             type string;
 *         }
 *         container connection {
 *             leaf ipAddress {
 *                 type ip-address;
 *             }
 *             leaf port {
 *                 type port;
 *             }
 *             leaf connected {
 *                 type boolean;
 *             }
 *             leaf-list error {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *             uses ccap-connection;
 *         }
 *         container amId {
 *             leaf am-tag {
 *                 type uint16;
 *             }
 *             leaf am-type {
 *                 type uint16;
 *             }
 *         }
 *         leaf-list subscriber-subnets {
 *             type ip-prefix;
 *         }
 *         leaf-list upstream-scns {
 *             type service-class-name;
 *         }
 *         leaf-list downstream-scns {
 *             type service-class-name;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         uses ccap-attributes;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccaps</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapsBuilder
 *
 */
public interface Ccaps
    extends
    ChildOf<PacketcableData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.Ccaps>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ccaps").intern();

    /**
     *  CCAP devices are known by their network name which is any string. Each CCAP 
     * device has a network address:port, a list of subscriber IP subnets, and a list 
     * of available Service Class Names. 
     *
     *
     *
     * @return <code>java.util.List</code> <code>ccap</code>, or <code>null</code> if not present
     */
    List<Ccap> getCcap();

}

