package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container input {
 *     leaf ccapId {
 *         type instance-identifier;
 *     }
 *     container connection {
 *         leaf connected {
 *             type boolean;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-set-connection/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapSetConnectionInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapSetConnectionInputBuilder
 *
 */
public interface CcapSetConnectionInput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapSetConnectionInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "input").intern();

    /**
     * @return <code>org.opendaylight.yangtools.yang.binding.InstanceIdentifier</code> <code>ccapId</code>, or <code>null</code> if not present
     */
    @RoutingContext
    (
    value=org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapContext.class
    )
    InstanceIdentifier<?> getCcapId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.set.connection.input.Connection</code> <code>connection</code>, or <code>null</code> if not present
     */
    Connection getConnection();

}

