package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput
 *
 */
public class CcapPollConnectionOutputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput> {

    private Ccap _ccap;
    private java.lang.String _response;
    private DateAndTime _timestamp;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> augmentation = Collections.emptyMap();

    public CcapPollConnectionOutputBuilder() {
    }

    public CcapPollConnectionOutputBuilder(CcapPollConnectionOutput base) {
        this._ccap = base.getCcap();
        this._response = base.getResponse();
        this._timestamp = base.getTimestamp();
        if (base instanceof CcapPollConnectionOutputImpl) {
            CcapPollConnectionOutputImpl impl = (CcapPollConnectionOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public Ccap getCcap() {
        return _ccap;
    }
    
    public java.lang.String getResponse() {
        return _response;
    }
    
    public DateAndTime getTimestamp() {
        return _timestamp;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public CcapPollConnectionOutputBuilder setCcap(final Ccap value) {
        this._ccap = value;
        return this;
    }
    
     
    public CcapPollConnectionOutputBuilder setResponse(final java.lang.String value) {
        this._response = value;
        return this;
    }
    
     
    public CcapPollConnectionOutputBuilder setTimestamp(final DateAndTime value) {
        this._timestamp = value;
        return this;
    }
    
    public CcapPollConnectionOutputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public CcapPollConnectionOutputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CcapPollConnectionOutput build() {
        return new CcapPollConnectionOutputImpl(this);
    }

    private static final class CcapPollConnectionOutputImpl implements CcapPollConnectionOutput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput.class;
        }

        private final Ccap _ccap;
        private final java.lang.String _response;
        private final DateAndTime _timestamp;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> augmentation = Collections.emptyMap();

        private CcapPollConnectionOutputImpl(CcapPollConnectionOutputBuilder base) {
            this._ccap = base.getCcap();
            this._response = base.getResponse();
            this._timestamp = base.getTimestamp();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ccap getCcap() {
            return _ccap;
        }
        
        @Override
        public java.lang.String getResponse() {
            return _response;
        }
        
        @Override
        public DateAndTime getTimestamp() {
            return _timestamp;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ccap);
            result = prime * result + Objects.hashCode(_response);
            result = prime * result + Objects.hashCode(_timestamp);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput)obj;
            if (!Objects.equals(_ccap, other.getCcap())) {
                return false;
            }
            if (!Objects.equals(_response, other.getResponse())) {
                return false;
            }
            if (!Objects.equals(_timestamp, other.getTimestamp())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CcapPollConnectionOutputImpl otherImpl = (CcapPollConnectionOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("CcapPollConnectionOutput [");
            boolean first = true;
        
            if (_ccap != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccap=");
                builder.append(_ccap);
             }
            if (_response != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_response=");
                builder.append(_response);
             }
            if (_timestamp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_timestamp=");
                builder.append(_timestamp);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
