package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * container output {
 *     container ccap {
 *         leaf ccapId {
 *             type string;
 *         }
 *         container connection {
 *             leaf ipAddress {
 *                 type ip-address;
 *             }
 *             leaf port {
 *                 type port;
 *             }
 *             leaf connected {
 *                 type boolean;
 *             }
 *             leaf-list error {
 *                 type string;
 *             }
 *             leaf timestamp {
 *                 type date-and-time;
 *             }
 *             uses ccap-connection;
 *         }
 *     }
 *     leaf response {
 *         type string;
 *     }
 *     leaf timestamp {
 *         type date-and-time;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-poll-connection/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutputBuilder
 *
 */
public interface CcapPollConnectionOutput
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "output").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.poll.connection.output.Ccap</code> <code>ccap</code>, or <code>null</code> if not present
     */
    Ccap getCcap();
    
    /**
     * @return <code>java.lang.String</code> <code>response</code>, or <code>null</code> if not present
     */
    java.lang.String getResponse();
    
    /**
     * RPC timestamp
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>timestamp</code>, or <code>null</code> if not present
     */
    DateAndTime getTimestamp();

}

