package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import java.util.Collections;
import java.util.Map;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput
 *
 */
public class CcapPollConnectionInputBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput> {

    private InstanceIdentifier<?> _ccapId;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> augmentation = Collections.emptyMap();

    public CcapPollConnectionInputBuilder() {
    }

    public CcapPollConnectionInputBuilder(CcapPollConnectionInput base) {
        this._ccapId = base.getCcapId();
        if (base instanceof CcapPollConnectionInputImpl) {
            CcapPollConnectionInputImpl impl = (CcapPollConnectionInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public InstanceIdentifier<?> getCcapId() {
        return _ccapId;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public CcapPollConnectionInputBuilder setCcapId(final InstanceIdentifier<?> value) {
        this._ccapId = value;
        return this;
    }
    
    public CcapPollConnectionInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public CcapPollConnectionInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CcapPollConnectionInput build() {
        return new CcapPollConnectionInputImpl(this);
    }

    private static final class CcapPollConnectionInputImpl implements CcapPollConnectionInput {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput.class;
        }

        private final InstanceIdentifier<?> _ccapId;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> augmentation = Collections.emptyMap();

        private CcapPollConnectionInputImpl(CcapPollConnectionInputBuilder base) {
            this._ccapId = base.getCcapId();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public InstanceIdentifier<?> getCcapId() {
            return _ccapId;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_ccapId);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput)obj;
            if (!Objects.equals(_ccapId, other.getCcapId())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                CcapPollConnectionInputImpl otherImpl = (CcapPollConnectionInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.CcapPollConnectionInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("CcapPollConnectionInput [");
            boolean first = true;
        
            if (_ccapId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ccapId=");
                builder.append(_ccapId);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
