package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping ccap-connection {
 *     leaf ipAddress {
 *         type ip-address;
 *     }
 *     leaf port {
 *         type port;
 *     }
 *     leaf connected {
 *         type boolean;
 *     }
 *     leaf-list error {
 *         type string;
 *     }
 *     leaf timestamp {
 *         type date-and-time;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-connection</i>
 *
 */
public interface CcapConnection
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ccap-connection").intern();

    /**
     * IP Address of CCAP
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress</code> <code>ipAddress</code>, or <code>null</code> if not present
     */
    IpAddress getIpAddress();
    
    /**
     * COPS session TCP port number
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>port</code>, or <code>null</code> if not present
     */
    PortNumber getPort();
    
    /**
     * COPS session state
     *
     *
     *
     * @return <code>java.lang.Boolean</code> <code>connected</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isConnected();
    
    /**
     * Operational errors
     *
     *
     *
     * @return <code>java.util.List</code> <code>error</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getError();
    
    /**
     * Last update timestamp
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime</code> <code>timestamp</code>, or <code>null</code> if not present
     */
    DateAndTime getTimestamp();

}

