package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.Connection;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId;
import java.util.List;


/**
 * Each CCAP device has a COPS connection address:port, a list of subscriber IP 
 * subnets, and a list of available Service Class Names. 
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * grouping ccap-attributes {
 *     container connection {
 *         leaf ipAddress {
 *             type ip-address;
 *         }
 *         leaf port {
 *             type port;
 *         }
 *         leaf connected {
 *             type boolean;
 *         }
 *         leaf-list error {
 *             type string;
 *         }
 *         leaf timestamp {
 *             type date-and-time;
 *         }
 *         uses ccap-connection;
 *     }
 *     container amId {
 *         leaf am-tag {
 *             type uint16;
 *         }
 *         leaf am-type {
 *             type uint16;
 *         }
 *     }
 *     leaf-list subscriber-subnets {
 *         type ip-prefix;
 *     }
 *     leaf-list upstream-scns {
 *         type service-class-name;
 *     }
 *     leaf-list downstream-scns {
 *         type service-class-name;
 *     }
 *     leaf-list error {
 *         type string;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/ccap-attributes</i>
 *
 */
public interface CcapAttributes
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "ccap-attributes").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.Connection</code> <code>connection</code>, or <code>null</code> if not present
     */
    Connection getConnection();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.packetcable.rev151101.ccap.attributes.AmId</code> <code>amId</code>, or <code>null</code> if not present
     */
    AmId getAmId();
    
    /**
     * @return <code>java.util.List</code> <code>subscriberSubnets</code>, or <code>null</code> if not present
     */
    List<IpPrefix> getSubscriberSubnets();
    
    /**
     * @return <code>java.util.List</code> <code>upstreamScns</code>, or <code>null</code> if not present
     */
    List<ServiceClassName> getUpstreamScns();
    
    /**
     * @return <code>java.util.List</code> <code>downstreamScns</code>, or <code>null</code> if not present
     */
    List<ServiceClassName> getDownstreamScns();
    
    /**
     * ccap data errors
     *
     *
     *
     * @return <code>java.util.List</code> <code>error</code>, or <code>null</code> if not present
     */
    List<java.lang.String> getError();

}

