package org.opendaylight.yang.gen.v1.urn.packetcable.rev151101;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;


/**
 * Identity used to mark app context
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>packetcable</b>
 * <pre>
 * identity app-context {
 *     description
 *         "Identity used to mark app context";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>packetcable/app-context</i>
 *
 */
public abstract class AppContext extends BaseIdentity
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable",
        "2015-11-01", "app-context").intern();


    public AppContext() {
    
    
    }
    






}

