package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier;
import com.google.common.collect.Range;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier
 *
 */
public class Ipv6ClassifierBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier> {

    private Ipv6Prefix _dstIp6;
    private PortNumber _dstPortEnd;
    private PortNumber _dstPortStart;
    private java.lang.Long _flowLabel;
    private TpProtocol _nextHdr;
    private Ipv6Prefix _srcIp6;
    private PortNumber _srcPortEnd;
    private PortNumber _srcPortStart;
    private TosByte _tcHigh;
    private TosByte _tcLow;
    private TosByte _tcMask;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentation = Collections.emptyMap();

    public Ipv6ClassifierBuilder() {
    }
    public Ipv6ClassifierBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges arg) {
        this._srcPortStart = arg.getSrcPortStart();
        this._srcPortEnd = arg.getSrcPortEnd();
        this._dstPortStart = arg.getDstPortStart();
        this._dstPortEnd = arg.getDstPortEnd();
    }

    public Ipv6ClassifierBuilder(Ipv6Classifier base) {
        this._dstIp6 = base.getDstIp6();
        this._dstPortEnd = base.getDstPortEnd();
        this._dstPortStart = base.getDstPortStart();
        this._flowLabel = base.getFlowLabel();
        this._nextHdr = base.getNextHdr();
        this._srcIp6 = base.getSrcIp6();
        this._srcPortEnd = base.getSrcPortEnd();
        this._srcPortStart = base.getSrcPortStart();
        this._tcHigh = base.getTcHigh();
        this._tcLow = base.getTcLow();
        this._tcMask = base.getTcMask();
        if (base instanceof Ipv6ClassifierImpl) {
            Ipv6ClassifierImpl impl = (Ipv6ClassifierImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges) {
            this._srcPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getSrcPortStart();
            this._srcPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getSrcPortEnd();
            this._dstPortStart = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getDstPortStart();
            this._dstPortEnd = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges)arg).getDstPortEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges] \n" +
              "but was: " + arg
            );
        }
    }

    public Ipv6Prefix getDstIp6() {
        return _dstIp6;
    }
    
    public PortNumber getDstPortEnd() {
        return _dstPortEnd;
    }
    
    public PortNumber getDstPortStart() {
        return _dstPortStart;
    }
    
    public java.lang.Long getFlowLabel() {
        return _flowLabel;
    }
    
    public TpProtocol getNextHdr() {
        return _nextHdr;
    }
    
    public Ipv6Prefix getSrcIp6() {
        return _srcIp6;
    }
    
    public PortNumber getSrcPortEnd() {
        return _srcPortEnd;
    }
    
    public PortNumber getSrcPortStart() {
        return _srcPortStart;
    }
    
    public TosByte getTcHigh() {
        return _tcHigh;
    }
    
    public TosByte getTcLow() {
        return _tcLow;
    }
    
    public TosByte getTcMask() {
        return _tcMask;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public Ipv6ClassifierBuilder setDstIp6(Ipv6Prefix value) {
        if (value != null) {
        }
        this._dstIp6 = value;
        return this;
    }
    
    private static void checkDstPortEndRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public Ipv6ClassifierBuilder setDstPortEnd(PortNumber value) {
        if (value != null) {
            checkDstPortEndRange(value.getValue());
        }
        this._dstPortEnd = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _dstPortEnd_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkDstPortStartRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public Ipv6ClassifierBuilder setDstPortStart(PortNumber value) {
        if (value != null) {
            checkDstPortStartRange(value.getValue());
        }
        this._dstPortStart = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _dstPortStart_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkFlowLabelRange(final long value) {
        if (value >= 0L && value <= 1048575L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥1048575]].", value));
    }
    
    public Ipv6ClassifierBuilder setFlowLabel(java.lang.Long value) {
        if (value != null) {
            checkFlowLabelRange(value);
        }
        this._flowLabel = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _flowLabel_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(1048575L)));
        return ret;
    }
    
    private static void checkNextHdrRange(final int value) {
        if (value >= 0 && value <= 257) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥257]].", value));
    }
    
    public Ipv6ClassifierBuilder setNextHdr(TpProtocol value) {
        if (value != null) {
            checkNextHdrRange(value.getValue());
        }
        this._nextHdr = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _nextHdr_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(257L)));
        return ret;
    }
    
    public Ipv6ClassifierBuilder setSrcIp6(Ipv6Prefix value) {
        if (value != null) {
        }
        this._srcIp6 = value;
        return this;
    }
    
    private static void checkSrcPortEndRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public Ipv6ClassifierBuilder setSrcPortEnd(PortNumber value) {
        if (value != null) {
            checkSrcPortEndRange(value.getValue());
        }
        this._srcPortEnd = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _srcPortEnd_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkSrcPortStartRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public Ipv6ClassifierBuilder setSrcPortStart(PortNumber value) {
        if (value != null) {
            checkSrcPortStartRange(value.getValue());
        }
        this._srcPortStart = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _srcPortStart_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    private static void checkTcHighRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public Ipv6ClassifierBuilder setTcHigh(TosByte value) {
        if (value != null) {
            checkTcHighRange(value.getValue());
        }
        this._tcHigh = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _tcHigh_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    private static void checkTcLowRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public Ipv6ClassifierBuilder setTcLow(TosByte value) {
        if (value != null) {
            checkTcLowRange(value.getValue());
        }
        this._tcLow = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _tcLow_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    private static void checkTcMaskRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public Ipv6ClassifierBuilder setTcMask(TosByte value) {
        if (value != null) {
            checkTcMaskRange(value.getValue());
        }
        this._tcMask = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _tcMask_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    public Ipv6ClassifierBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public Ipv6ClassifierBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6Classifier build() {
        return new Ipv6ClassifierImpl(this);
    }

    private static final class Ipv6ClassifierImpl implements Ipv6Classifier {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier.class;
        }

        private final Ipv6Prefix _dstIp6;
        private final PortNumber _dstPortEnd;
        private final PortNumber _dstPortStart;
        private final java.lang.Long _flowLabel;
        private final TpProtocol _nextHdr;
        private final Ipv6Prefix _srcIp6;
        private final PortNumber _srcPortEnd;
        private final PortNumber _srcPortStart;
        private final TosByte _tcHigh;
        private final TosByte _tcLow;
        private final TosByte _tcMask;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> augmentation = Collections.emptyMap();

        private Ipv6ClassifierImpl(Ipv6ClassifierBuilder base) {
            this._dstIp6 = base.getDstIp6();
            this._dstPortEnd = base.getDstPortEnd();
            this._dstPortStart = base.getDstPortStart();
            this._flowLabel = base.getFlowLabel();
            this._nextHdr = base.getNextHdr();
            this._srcIp6 = base.getSrcIp6();
            this._srcPortEnd = base.getSrcPortEnd();
            this._srcPortStart = base.getSrcPortStart();
            this._tcHigh = base.getTcHigh();
            this._tcLow = base.getTcLow();
            this._tcMask = base.getTcMask();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Ipv6Prefix getDstIp6() {
            return _dstIp6;
        }
        
        @Override
        public PortNumber getDstPortEnd() {
            return _dstPortEnd;
        }
        
        @Override
        public PortNumber getDstPortStart() {
            return _dstPortStart;
        }
        
        @Override
        public java.lang.Long getFlowLabel() {
            return _flowLabel;
        }
        
        @Override
        public TpProtocol getNextHdr() {
            return _nextHdr;
        }
        
        @Override
        public Ipv6Prefix getSrcIp6() {
            return _srcIp6;
        }
        
        @Override
        public PortNumber getSrcPortEnd() {
            return _srcPortEnd;
        }
        
        @Override
        public PortNumber getSrcPortStart() {
            return _srcPortStart;
        }
        
        @Override
        public TosByte getTcHigh() {
            return _tcHigh;
        }
        
        @Override
        public TosByte getTcLow() {
            return _tcLow;
        }
        
        @Override
        public TosByte getTcMask() {
            return _tcMask;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_dstIp6 == null) ? 0 : _dstIp6.hashCode());
            result = prime * result + ((_dstPortEnd == null) ? 0 : _dstPortEnd.hashCode());
            result = prime * result + ((_dstPortStart == null) ? 0 : _dstPortStart.hashCode());
            result = prime * result + ((_flowLabel == null) ? 0 : _flowLabel.hashCode());
            result = prime * result + ((_nextHdr == null) ? 0 : _nextHdr.hashCode());
            result = prime * result + ((_srcIp6 == null) ? 0 : _srcIp6.hashCode());
            result = prime * result + ((_srcPortEnd == null) ? 0 : _srcPortEnd.hashCode());
            result = prime * result + ((_srcPortStart == null) ? 0 : _srcPortStart.hashCode());
            result = prime * result + ((_tcHigh == null) ? 0 : _tcHigh.hashCode());
            result = prime * result + ((_tcLow == null) ? 0 : _tcLow.hashCode());
            result = prime * result + ((_tcMask == null) ? 0 : _tcMask.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier)obj;
            if (_dstIp6 == null) {
                if (other.getDstIp6() != null) {
                    return false;
                }
            } else if(!_dstIp6.equals(other.getDstIp6())) {
                return false;
            }
            if (_dstPortEnd == null) {
                if (other.getDstPortEnd() != null) {
                    return false;
                }
            } else if(!_dstPortEnd.equals(other.getDstPortEnd())) {
                return false;
            }
            if (_dstPortStart == null) {
                if (other.getDstPortStart() != null) {
                    return false;
                }
            } else if(!_dstPortStart.equals(other.getDstPortStart())) {
                return false;
            }
            if (_flowLabel == null) {
                if (other.getFlowLabel() != null) {
                    return false;
                }
            } else if(!_flowLabel.equals(other.getFlowLabel())) {
                return false;
            }
            if (_nextHdr == null) {
                if (other.getNextHdr() != null) {
                    return false;
                }
            } else if(!_nextHdr.equals(other.getNextHdr())) {
                return false;
            }
            if (_srcIp6 == null) {
                if (other.getSrcIp6() != null) {
                    return false;
                }
            } else if(!_srcIp6.equals(other.getSrcIp6())) {
                return false;
            }
            if (_srcPortEnd == null) {
                if (other.getSrcPortEnd() != null) {
                    return false;
                }
            } else if(!_srcPortEnd.equals(other.getSrcPortEnd())) {
                return false;
            }
            if (_srcPortStart == null) {
                if (other.getSrcPortStart() != null) {
                    return false;
                }
            } else if(!_srcPortStart.equals(other.getSrcPortStart())) {
                return false;
            }
            if (_tcHigh == null) {
                if (other.getTcHigh() != null) {
                    return false;
                }
            } else if(!_tcHigh.equals(other.getTcHigh())) {
                return false;
            }
            if (_tcLow == null) {
                if (other.getTcLow() != null) {
                    return false;
                }
            } else if(!_tcLow.equals(other.getTcLow())) {
                return false;
            }
            if (_tcMask == null) {
                if (other.getTcMask() != null) {
                    return false;
                }
            } else if(!_tcMask.equals(other.getTcMask())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                Ipv6ClassifierImpl otherImpl = (Ipv6ClassifierImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Ipv6Classifier [");
            boolean first = true;
        
            if (_dstIp6 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp6=");
                builder.append(_dstIp6);
             }
            if (_dstPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortEnd=");
                builder.append(_dstPortEnd);
             }
            if (_dstPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortStart=");
                builder.append(_dstPortStart);
             }
            if (_flowLabel != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flowLabel=");
                builder.append(_flowLabel);
             }
            if (_nextHdr != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nextHdr=");
                builder.append(_nextHdr);
             }
            if (_srcIp6 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp6=");
                builder.append(_srcIp6);
             }
            if (_srcPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortEnd=");
                builder.append(_srcPortEnd);
             }
            if (_srcPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortStart=");
                builder.append(_srcPortStart);
             }
            if (_tcHigh != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcHigh=");
                builder.append(_tcHigh);
             }
            if (_tcLow != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcLow=");
                builder.append(_tcLow);
             }
            if (_tcMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tcMask=");
                builder.append(_tcMask);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
