package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.traffic.profile.TrafficProfile;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.Classifier;
import java.util.HashMap;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates
 *
 */
public class GatesBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates> {

    private Classifier _classifier;
    private ExtClassifier _extClassifier;
    private java.lang.String _gateId;
    private GateSpec _gateSpec;
    private Ipv6Classifier _ipv6Classifier;
    private GatesKey _key;
    private TrafficProfile _trafficProfile;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> augmentation = Collections.emptyMap();

    public GatesBuilder() {
    }
    public GatesBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec arg) {
        this._gateSpec = arg.getGateSpec();
    }
    public GatesBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier arg) {
        this._classifier = arg.getClassifier();
    }
    public GatesBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier arg) {
        this._ipv6Classifier = arg.getIpv6Classifier();
    }
    public GatesBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile arg) {
        this._trafficProfile = arg.getTrafficProfile();
    }
    public GatesBuilder(org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier arg) {
        this._extClassifier = arg.getExtClassifier();
    }

    public GatesBuilder(Gates base) {
        if (base.getKey() == null) {
            this._key = new GatesKey(
                base.getGateId()
            );
            this._gateId = base.getGateId();
        } else {
            this._key = base.getKey();
            this._gateId = _key.getGateId();
        }
        this._classifier = base.getClassifier();
        this._extClassifier = base.getExtClassifier();
        this._gateSpec = base.getGateSpec();
        this._ipv6Classifier = base.getIpv6Classifier();
        this._trafficProfile = base.getTrafficProfile();
        if (base instanceof GatesImpl) {
            GatesImpl impl = (GatesImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec</li>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier</li>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile</li>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier</li>
     * <li>org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec) {
            this._gateSpec = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec)arg).getGateSpec();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier) {
            this._ipv6Classifier = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier)arg).getIpv6Classifier();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile) {
            this._trafficProfile = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile)arg).getTrafficProfile();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier) {
            this._classifier = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier)arg).getClassifier();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier) {
            this._extClassifier = ((org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier)arg).getExtClassifier();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosTrafficProfile, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier, org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosExtClassifier] \n" +
              "but was: " + arg
            );
        }
    }

    public Classifier getClassifier() {
        return _classifier;
    }
    
    public ExtClassifier getExtClassifier() {
        return _extClassifier;
    }
    
    public java.lang.String getGateId() {
        return _gateId;
    }
    
    public GateSpec getGateSpec() {
        return _gateSpec;
    }
    
    public Ipv6Classifier getIpv6Classifier() {
        return _ipv6Classifier;
    }
    
    public GatesKey getKey() {
        return _key;
    }
    
    public TrafficProfile getTrafficProfile() {
        return _trafficProfile;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public GatesBuilder setClassifier(Classifier value) {
        this._classifier = value;
        return this;
    }
    
    public GatesBuilder setExtClassifier(ExtClassifier value) {
        this._extClassifier = value;
        return this;
    }
    
    public GatesBuilder setGateId(java.lang.String value) {
        this._gateId = value;
        return this;
    }
    
    public GatesBuilder setGateSpec(GateSpec value) {
        this._gateSpec = value;
        return this;
    }
    
    public GatesBuilder setIpv6Classifier(Ipv6Classifier value) {
        this._ipv6Classifier = value;
        return this;
    }
    
    public GatesBuilder setKey(GatesKey value) {
        this._key = value;
        return this;
    }
    
    public GatesBuilder setTrafficProfile(TrafficProfile value) {
        this._trafficProfile = value;
        return this;
    }
    
    public GatesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public GatesBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Gates build() {
        return new GatesImpl(this);
    }

    private static final class GatesImpl implements Gates {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates.class;
        }

        private final Classifier _classifier;
        private final ExtClassifier _extClassifier;
        private final java.lang.String _gateId;
        private final GateSpec _gateSpec;
        private final Ipv6Classifier _ipv6Classifier;
        private final GatesKey _key;
        private final TrafficProfile _trafficProfile;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> augmentation = Collections.emptyMap();

        private GatesImpl(GatesBuilder base) {
            if (base.getKey() == null) {
                this._key = new GatesKey(
                    base.getGateId()
                );
                this._gateId = base.getGateId();
            } else {
                this._key = base.getKey();
                this._gateId = _key.getGateId();
            }
            this._classifier = base.getClassifier();
            this._extClassifier = base.getExtClassifier();
            this._gateSpec = base.getGateSpec();
            this._ipv6Classifier = base.getIpv6Classifier();
            this._trafficProfile = base.getTrafficProfile();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Classifier getClassifier() {
            return _classifier;
        }
        
        @Override
        public ExtClassifier getExtClassifier() {
            return _extClassifier;
        }
        
        @Override
        public java.lang.String getGateId() {
            return _gateId;
        }
        
        @Override
        public GateSpec getGateSpec() {
            return _gateSpec;
        }
        
        @Override
        public Ipv6Classifier getIpv6Classifier() {
            return _ipv6Classifier;
        }
        
        @Override
        public GatesKey getKey() {
            return _key;
        }
        
        @Override
        public TrafficProfile getTrafficProfile() {
            return _trafficProfile;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_classifier == null) ? 0 : _classifier.hashCode());
            result = prime * result + ((_extClassifier == null) ? 0 : _extClassifier.hashCode());
            result = prime * result + ((_gateId == null) ? 0 : _gateId.hashCode());
            result = prime * result + ((_gateSpec == null) ? 0 : _gateSpec.hashCode());
            result = prime * result + ((_ipv6Classifier == null) ? 0 : _ipv6Classifier.hashCode());
            result = prime * result + ((_key == null) ? 0 : _key.hashCode());
            result = prime * result + ((_trafficProfile == null) ? 0 : _trafficProfile.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates)obj;
            if (_classifier == null) {
                if (other.getClassifier() != null) {
                    return false;
                }
            } else if(!_classifier.equals(other.getClassifier())) {
                return false;
            }
            if (_extClassifier == null) {
                if (other.getExtClassifier() != null) {
                    return false;
                }
            } else if(!_extClassifier.equals(other.getExtClassifier())) {
                return false;
            }
            if (_gateId == null) {
                if (other.getGateId() != null) {
                    return false;
                }
            } else if(!_gateId.equals(other.getGateId())) {
                return false;
            }
            if (_gateSpec == null) {
                if (other.getGateSpec() != null) {
                    return false;
                }
            } else if(!_gateSpec.equals(other.getGateSpec())) {
                return false;
            }
            if (_ipv6Classifier == null) {
                if (other.getIpv6Classifier() != null) {
                    return false;
                }
            } else if(!_ipv6Classifier.equals(other.getIpv6Classifier())) {
                return false;
            }
            if (_key == null) {
                if (other.getKey() != null) {
                    return false;
                }
            } else if(!_key.equals(other.getKey())) {
                return false;
            }
            if (_trafficProfile == null) {
                if (other.getTrafficProfile() != null) {
                    return false;
                }
            } else if(!_trafficProfile.equals(other.getTrafficProfile())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GatesImpl otherImpl = (GatesImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Gates [");
            boolean first = true;
        
            if (_classifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classifier=");
                builder.append(_classifier);
             }
            if (_extClassifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_extClassifier=");
                builder.append(_extClassifier);
             }
            if (_gateId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gateId=");
                builder.append(_gateId);
             }
            if (_gateSpec != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gateSpec=");
                builder.append(_gateSpec);
             }
            if (_ipv6Classifier != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipv6Classifier=");
                builder.append(_ipv6Classifier);
             }
            if (_key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(_key);
             }
            if (_trafficProfile != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_trafficProfile=");
                builder.append(_trafficProfile);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
