package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateSpec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ServiceFlowDirection;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container gate-spec {
 *     leaf direction {
 *         type service-flow-direction;
 *     }
 *     leaf dscp-tos-overwrite {
 *         type tos-byte;
 *     }
 *     leaf dscp-tos-mask {
 *         type tos-byte;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-gate-spec/gate-spec&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpecBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpecBuilder
 *
 */
public interface GateSpec
    extends
    ChildOf<PcmmQosGateSpec>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gate.spec.GateSpec>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","gate-spec"));

    /**
     * Gate Direction (ignored for traffic profile SCN)
     *
     */
    ServiceFlowDirection getDirection();
    
    /**
     * Optional DSCP/TOS overwrite value
     *
     */
    TosByte getDscpTosOverwrite();
    
    /**
     * Optional DSCP/TOS overwrite AND mask
     *
     */
    TosByte getDscpTosMask();

}

