package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosClassifier;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container classifier {
 *     leaf srcIp {
 *         type ipv4-address;
 *     }
 *     leaf dstIp {
 *         type ipv4-address;
 *     }
 *     leaf tos-byte {
 *         type tos-byte;
 *     }
 *     leaf tos-mask {
 *         type tos-byte;
 *     }
 *     leaf protocol {
 *         type tp-protocol;
 *     }
 *     leaf srcPort {
 *         type port-number;
 *     }
 *     leaf dstPort {
 *         type port-number;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-classifier/classifier&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.ClassifierBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.ClassifierBuilder
 *
 */
public interface Classifier
    extends
    ChildOf<PcmmQosClassifier>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.classifier.Classifier>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","classifier"));

    /**
     * Source IPv4 address (exact match)
     *
     */
    Ipv4Address getSrcIp();
    
    /**
     * Destination IPv4 address (exact match)
     *
     */
    Ipv4Address getDstIp();
    
    /**
     * TOS/DSCP match
     *
     */
    TosByte getTosByte();
    
    /**
     * TOS/DSCP mask
     *
     */
    TosByte getTosMask();
    
    /**
     * IPv4 transport protocol
     *
     */
    TpProtocol getProtocol();
    
    /**
     * TCP/UDP source port (exact match).
     *
     */
    PortNumber getSrcPort();
    
    /**
     * TCP/UDP destination port (exact match).
     *
     */
    PortNumber getDstPort();

}

