package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;


/**
 * The enumeration built-in type represents values from a set of assigned names.
 *
 */
public enum ServiceFlowDirection {
    /**
     * Upstream service flow.
     *
     */
    Us(1),
    
    /**
     * Downstream service flow.
     *
     */
    Ds(2)
    ;


    int value;
    private static final java.util.Map<java.lang.Integer, ServiceFlowDirection> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, ServiceFlowDirection> b = com.google.common.collect.ImmutableMap.builder();
        for (ServiceFlowDirection enumItem : ServiceFlowDirection.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private ServiceFlowDirection(int value) {
        this.value = value;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding ServiceFlowDirection item
     */
    public static ServiceFlowDirection forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
