package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpPrefix;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.AmId;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection;


/**
 * Each CCAP device has a COPS connection address:port,a list of subscriber IP 
 * subnets, anda list of available Service Class Names.
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping ccap-attributes {
 *     container connection {
 *         leaf ipAddress {
 *             type ip-address;
 *         }
 *         leaf port {
 *             type port-number;
 *         }
 *     }
 *     container amId {
 *         leaf am-tag {
 *             type uint16;
 *         }
 *         leaf am-type {
 *             type uint16;
 *         }
 *     }
 *     leaf-list subscriber-subnets {
 *         type ip-prefix;
 *     }
 *     leaf-list upstream-scns {
 *         type service-class-name;
 *     }
 *     leaf-list downstream-scns {
 *         type service-class-name;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/ccap-attributes&lt;/i&gt;
 *
 */
public interface CcapAttributes
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","ccap-attributes"));

    Connection getConnection();
    
    AmId getAmId();
    
    List<IpPrefix> getSubscriberSubnets();
    
    List<ServiceClassName> getUpstreamScns();
    
    List<ServiceClassName> getDownstreamScns();

}

