package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosIpv6Classifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container ipv6-classifier {
 *     leaf srcIp6 {
 *         type ipv6-prefix;
 *     }
 *     leaf dstIp6 {
 *         type ipv6-prefix;
 *     }
 *     leaf tc-low {
 *         type tos-byte;
 *     }
 *     leaf tc-high {
 *         type tos-byte;
 *     }
 *     leaf tc-mask {
 *         type tos-byte;
 *     }
 *     leaf next-hdr {
 *         type tp-protocol;
 *     }
 *     leaf flow-label {
 *         type uint32;
 *     }
 *     leaf srcPort-start {
 *         type port-number;
 *     }
 *     leaf srcPort-end {
 *         type port-number;
 *     }
 *     leaf dstPort-start {
 *         type port-number;
 *     }
 *     leaf dstPort-end {
 *         type port-number;
 *     }
 *     uses tp-port-match-ranges;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-ipv6-classifier/ipv6-classifier&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6ClassifierBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6ClassifierBuilder
 *
 */
public interface Ipv6Classifier
    extends
    ChildOf<PcmmQosIpv6Classifier>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ipv6.classifier.Ipv6Classifier>,
    TpPortMatchRanges
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","ipv6-classifier"));

    /**
     * Source IPv6 prefix match in &lt;address/len&gt; notation
     *
     */
    Ipv6Prefix getSrcIp6();
    
    /**
     * Destination IPv6 prefix match in &lt;address/len&gt; notation
     *
     */
    Ipv6Prefix getDstIp6();
    
    /**
     * TC low range match
     *
     */
    TosByte getTcLow();
    
    /**
     * TC high range match
     *
     */
    TosByte getTcHigh();
    
    /**
     * TC mask
     *
     */
    TosByte getTcMask();
    
    /**
     * IPv6 Next Header
     *
     */
    TpProtocol getNextHdr();
    
    /**
     * IPv6 Flow Label (20 bits)
     *
     */
    java.lang.Long getFlowLabel();

}

