package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import java.util.List;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection
 *
 */
public class ConnectionBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection> {

    private IpAddress _ipAddress;
    private PortNumber _port;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> augmentation = Collections.emptyMap();

    public ConnectionBuilder() {
    }

    public ConnectionBuilder(Connection base) {
        this._ipAddress = base.getIpAddress();
        this._port = base.getPort();
        if (base instanceof ConnectionImpl) {
            ConnectionImpl impl = (ConnectionImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public IpAddress getIpAddress() {
        return _ipAddress;
    }
    
    public PortNumber getPort() {
        return _port;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public ConnectionBuilder setIpAddress(IpAddress value) {
        if (value != null) {
        }
        this._ipAddress = value;
        return this;
    }
    
    private static void checkPortRange(final int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
    }
    
    public ConnectionBuilder setPort(PortNumber value) {
        if (value != null) {
            checkPortRange(value.getValue());
        }
        this._port = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _port_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
        return ret;
    }
    
    public ConnectionBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ConnectionBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Connection build() {
        return new ConnectionImpl(this);
    }

    private static final class ConnectionImpl implements Connection {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection.class;
        }

        private final IpAddress _ipAddress;
        private final PortNumber _port;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> augmentation = Collections.emptyMap();

        private ConnectionImpl(ConnectionBuilder base) {
            this._ipAddress = base.getIpAddress();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public IpAddress getIpAddress() {
            return _ipAddress;
        }
        
        @Override
        public PortNumber getPort() {
            return _port;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_ipAddress == null) ? 0 : _ipAddress.hashCode());
            result = prime * result + ((_port == null) ? 0 : _port.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection other = (org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection)obj;
            if (_ipAddress == null) {
                if (other.getIpAddress() != null) {
                    return false;
                }
            } else if(!_ipAddress.equals(other.getIpAddress())) {
                return false;
            }
            if (_port == null) {
                if (other.getPort() != null) {
                    return false;
                }
            } else if(!_port.equals(other.getPort())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ConnectionImpl otherImpl = (ConnectionImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>>, Augmentation<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Connection [");
            boolean first = true;
        
            if (_ipAddress != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ipAddress=");
                builder.append(_ipAddress);
             }
            if (_port != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_port=");
                builder.append(_port);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
