package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.CcapAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.IpAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container connection {
 *     leaf ipAddress {
 *         type ip-address;
 *     }
 *     leaf port {
 *         type port-number;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/ccap-attributes/connection&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.ConnectionBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.ConnectionBuilder
 *
 */
public interface Connection
    extends
    ChildOf<CcapAttributes>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.ccap.attributes.Connection>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","connection"));

    /**
     * IP Address of CCAP
     *
     */
    IpAddress getIpAddress();
    
    /**
     * COPS session TCP port number
     *
     */
    PortNumber getPort();

}

