package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * This module contains the PCMM Converged Cable Access Platform (CCAP) definitions
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * module packetcable {
 *     yang-version 1;
 *     namespace "urn:packetcable";
 *     prefix "pcmm";
 *
 *     import ietf-yang-types { prefix "yang"; }
 *     
 *     import ietf-inet-types { prefix "inet"; }
 *     revision 2015-03-27 {
 *         description "This module contains the PCMM Converged Cable Access Platform (CCAP) definitions
 *         ";
 *     }
 *
 *     container ccap {
 *         list ccaps {
 *             key "ccapId"
 *             leaf ccapId {
 *                 type string;
 *             }
 *             container connection {
 *                 leaf ipAddress {
 *                     type ip-address;
 *                 }
 *                 leaf port {
 *                     type port-number;
 *                 }
 *             }
 *             container amId {
 *                 leaf am-tag {
 *                     type uint16;
 *                 }
 *                 leaf am-type {
 *                     type uint16;
 *                 }
 *             }
 *             leaf-list subscriber-subnets {
 *                 type ip-prefix;
 *             }
 *             leaf-list upstream-scns {
 *                 type service-class-name;
 *             }
 *             leaf-list downstream-scns {
 *                 type service-class-name;
 *             }
 *             uses ccap-attributes;
 *         }
 *     }
 *     container qos {
 *         list apps {
 *             key "appId"
 *             leaf appId {
 *                 type string;
 *             }
 *             list subs {
 *                 key "subId"
 *                 leaf subId {
 *                     type string;
 *                 }
 *                 list gates {
 *                     key "gateId"
 *                     leaf gateId {
 *                         type string;
 *                     }
 *                     container gate-spec {
 *                         leaf direction {
 *                             type service-flow-direction;
 *                         }
 *                         leaf dscp-tos-overwrite {
 *                             type tos-byte;
 *                         }
 *                         leaf dscp-tos-mask {
 *                             type tos-byte;
 *                         }
 *                     }
 *                     container classifier {
 *                         leaf srcIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf tos-byte {
 *                             type tos-byte;
 *                         }
 *                         leaf tos-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf protocol {
 *                             type tp-protocol;
 *                         }
 *                         leaf srcPort {
 *                             type port-number;
 *                         }
 *                         leaf dstPort {
 *                             type port-number;
 *                         }
 *                     }
 *                     container ipv6-classifier {
 *                         leaf srcIp6 {
 *                             type ipv6-prefix;
 *                         }
 *                         leaf dstIp6 {
 *                             type ipv6-prefix;
 *                         }
 *                         leaf tc-low {
 *                             type tos-byte;
 *                         }
 *                         leaf tc-high {
 *                             type tos-byte;
 *                         }
 *                         leaf tc-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf next-hdr {
 *                             type tp-protocol;
 *                         }
 *                         leaf flow-label {
 *                             type uint32;
 *                         }
 *                         leaf srcPort-start {
 *                             type port-number;
 *                         }
 *                         leaf srcPort-end {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-start {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-end {
 *                             type port-number;
 *                         }
 *                         uses tp-port-match-ranges;
 *                     }
 *                     container traffic-profile {
 *                         leaf service-class-name {
 *                             type service-class-name;
 *                         }
 *                     }
 *                     container ext-classifier {
 *                         leaf srcIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf srcIpMask {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIpMask {
 *                             type ipv4-address;
 *                         }
 *                         leaf tos-byte {
 *                             type tos-byte;
 *                         }
 *                         leaf tos-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf protocol {
 *                             type tp-protocol;
 *                         }
 *                         leaf srcPort-start {
 *                             type port-number;
 *                         }
 *                         leaf srcPort-end {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-start {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-end {
 *                             type port-number;
 *                         }
 *                         uses tp-port-match-ranges;
 *                     }
 *                     uses pcmm-qos-gate-attributes;
 *                 }
 *             }
 *         }
 *         uses pcmm-qos-gates;
 *     }
 *
 *     grouping ccap-attributes {
 *         container connection {
 *             leaf ipAddress {
 *                 type ip-address;
 *             }
 *             leaf port {
 *                 type port-number;
 *             }
 *         }
 *         container amId {
 *             leaf am-tag {
 *                 type uint16;
 *             }
 *             leaf am-type {
 *                 type uint16;
 *             }
 *         }
 *         leaf-list subscriber-subnets {
 *             type ip-prefix;
 *         }
 *         leaf-list upstream-scns {
 *             type service-class-name;
 *         }
 *         leaf-list downstream-scns {
 *             type service-class-name;
 *         }
 *     }
 *     grouping pcmm-qos-classifier {
 *         container classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort {
 *                 type port-number;
 *             }
 *             leaf dstPort {
 *                 type port-number;
 *             }
 *         }
 *     }
 *     grouping pcmm-qos-ext-classifier {
 *         container ext-classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf srcIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *     }
 *     grouping pcmm-qos-gate-attributes {
 *         container gate-spec {
 *             leaf direction {
 *                 type service-flow-direction;
 *             }
 *             leaf dscp-tos-overwrite {
 *                 type tos-byte;
 *             }
 *             leaf dscp-tos-mask {
 *                 type tos-byte;
 *             }
 *         }
 *         container classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort {
 *                 type port-number;
 *             }
 *             leaf dstPort {
 *                 type port-number;
 *             }
 *         }
 *         container ipv6-classifier {
 *             leaf srcIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf dstIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf tc-low {
 *                 type tos-byte;
 *             }
 *             leaf tc-high {
 *                 type tos-byte;
 *             }
 *             leaf tc-mask {
 *                 type tos-byte;
 *             }
 *             leaf next-hdr {
 *                 type tp-protocol;
 *             }
 *             leaf flow-label {
 *                 type uint32;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *         container traffic-profile {
 *             leaf service-class-name {
 *                 type service-class-name;
 *             }
 *         }
 *         container ext-classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf srcIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *     }
 *     grouping pcmm-qos-gate-spec {
 *         container gate-spec {
 *             leaf direction {
 *                 type service-flow-direction;
 *             }
 *             leaf dscp-tos-overwrite {
 *                 type tos-byte;
 *             }
 *             leaf dscp-tos-mask {
 *                 type tos-byte;
 *             }
 *         }
 *     }
 *     grouping pcmm-qos-gates {
 *         list apps {
 *             key "appId"
 *             leaf appId {
 *                 type string;
 *             }
 *             list subs {
 *                 key "subId"
 *                 leaf subId {
 *                     type string;
 *                 }
 *                 list gates {
 *                     key "gateId"
 *                     leaf gateId {
 *                         type string;
 *                     }
 *                     container gate-spec {
 *                         leaf direction {
 *                             type service-flow-direction;
 *                         }
 *                         leaf dscp-tos-overwrite {
 *                             type tos-byte;
 *                         }
 *                         leaf dscp-tos-mask {
 *                             type tos-byte;
 *                         }
 *                     }
 *                     container classifier {
 *                         leaf srcIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf tos-byte {
 *                             type tos-byte;
 *                         }
 *                         leaf tos-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf protocol {
 *                             type tp-protocol;
 *                         }
 *                         leaf srcPort {
 *                             type port-number;
 *                         }
 *                         leaf dstPort {
 *                             type port-number;
 *                         }
 *                     }
 *                     container ipv6-classifier {
 *                         leaf srcIp6 {
 *                             type ipv6-prefix;
 *                         }
 *                         leaf dstIp6 {
 *                             type ipv6-prefix;
 *                         }
 *                         leaf tc-low {
 *                             type tos-byte;
 *                         }
 *                         leaf tc-high {
 *                             type tos-byte;
 *                         }
 *                         leaf tc-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf next-hdr {
 *                             type tp-protocol;
 *                         }
 *                         leaf flow-label {
 *                             type uint32;
 *                         }
 *                         leaf srcPort-start {
 *                             type port-number;
 *                         }
 *                         leaf srcPort-end {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-start {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-end {
 *                             type port-number;
 *                         }
 *                         uses tp-port-match-ranges;
 *                     }
 *                     container traffic-profile {
 *                         leaf service-class-name {
 *                             type service-class-name;
 *                         }
 *                     }
 *                     container ext-classifier {
 *                         leaf srcIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf srcIpMask {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIp {
 *                             type ipv4-address;
 *                         }
 *                         leaf dstIpMask {
 *                             type ipv4-address;
 *                         }
 *                         leaf tos-byte {
 *                             type tos-byte;
 *                         }
 *                         leaf tos-mask {
 *                             type tos-byte;
 *                         }
 *                         leaf protocol {
 *                             type tp-protocol;
 *                         }
 *                         leaf srcPort-start {
 *                             type port-number;
 *                         }
 *                         leaf srcPort-end {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-start {
 *                             type port-number;
 *                         }
 *                         leaf dstPort-end {
 *                             type port-number;
 *                         }
 *                         uses tp-port-match-ranges;
 *                     }
 *                     uses pcmm-qos-gate-attributes;
 *                 }
 *             }
 *         }
 *     }
 *     grouping pcmm-qos-ipv6-classifier {
 *         container ipv6-classifier {
 *             leaf srcIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf dstIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf tc-low {
 *                 type tos-byte;
 *             }
 *             leaf tc-high {
 *                 type tos-byte;
 *             }
 *             leaf tc-mask {
 *                 type tos-byte;
 *             }
 *             leaf next-hdr {
 *                 type tp-protocol;
 *             }
 *             leaf flow-label {
 *                 type uint32;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *     }
 *     grouping pcmm-qos-traffic-profile {
 *         container traffic-profile {
 *             leaf service-class-name {
 *                 type service-class-name;
 *             }
 *         }
 *     }
 *     grouping tp-port-match-ranges {
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 *
 */
public interface PacketcableData
    extends
    DataRoot
{




    Ccap getCcap();
    
    /**
     * PCMM QoS Gates are organized as a tree by Application/Subscriber/Gate: Each 
     * Application is known by its appId which is any string. Each Subscriber is known 
     * by its subId which is a CPE IP address in either IPv4 or IPv6 format. Each Gate 
     * is known by its gateId which is any string. The subscriber's CPE IP address is 
     * used to locate the CCAP device that is currently hosting the the Cable Modem 
     * that is connected to the subscriber's device. Therefore, it is not necessary for
     * the PCMM applications to know the topology of the CCAP devices and CMs in the 
     * network path to their subscriber devices. Note that each CCAP entry contains a 
     * list of connected subscriber IP subnets as well as a list of all Service Class 
     * Names (SCNs) available on the CCAP device.
     *
     */
    Qos getQos();

}

