/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.Subs;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.SubsKey;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SubsBuilder
implements Builder<Subs> {
    private List<Gates> _gates;
    private SubsKey _key;
    private String _subId;
    Map<Class<? extends Augmentation<Subs>>, Augmentation<Subs>> augmentation = Collections.emptyMap();

    public SubsBuilder() {
    }

    public SubsBuilder(Subs base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new SubsKey(base.getSubId());
            this._subId = base.getSubId();
        } else {
            this._key = base.getKey();
            this._subId = this._key.getSubId();
        }
        this._gates = base.getGates();
        if (base instanceof SubsImpl) {
            SubsImpl impl = (SubsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Subs>>, Augmentation<Subs>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Subs>>, Augmentation<Subs>>(casted.augmentations());
        }
    }

    public List<Gates> getGates() {
        return this._gates;
    }

    public SubsKey getKey() {
        return this._key;
    }

    public String getSubId() {
        return this._subId;
    }

    public <E extends Augmentation<Subs>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SubsBuilder setGates(List<Gates> value) {
        this._gates = value;
        return this;
    }

    public SubsBuilder setKey(SubsKey value) {
        this._key = value;
        return this;
    }

    public SubsBuilder setSubId(String value) {
        this._subId = value;
        return this;
    }

    public SubsBuilder addAugmentation(Class<? extends Augmentation<Subs>> augmentationType, Augmentation<Subs> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Subs>>, Augmentation<Subs>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SubsBuilder removeAugmentation(Class<? extends Augmentation<Subs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Subs build() {
        return new SubsImpl(this);
    }

    private static final class SubsImpl
    implements Subs {
        private final List<Gates> _gates;
        private final SubsKey _key;
        private final String _subId;
        private Map<Class<? extends Augmentation<Subs>>, Augmentation<Subs>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Subs> getImplementedInterface() {
            return Subs.class;
        }

        private SubsImpl(SubsBuilder base) {
            if (base.getKey() == null) {
                this._key = new SubsKey(base.getSubId());
                this._subId = base.getSubId();
            } else {
                this._key = base.getKey();
                this._subId = this._key.getSubId();
            }
            this._gates = base.getGates();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Subs>>, Augmentation<Subs>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Subs>>, Augmentation<Subs>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Gates> getGates() {
            return this._gates;
        }

        @Override
        public SubsKey getKey() {
            return this._key;
        }

        @Override
        public String getSubId() {
            return this._subId;
        }

        public <E extends Augmentation<Subs>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._gates == null ? 0 : this._gates.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._subId == null ? 0 : this._subId.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Subs.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Subs other = (Subs)obj;
            if (this._gates == null ? other.getGates() != null : !this._gates.equals(other.getGates())) {
                return false;
            }
            if (this._key == null ? other.getKey() != null : !this._key.equals(other.getKey())) {
                return false;
            }
            if (this._subId == null ? other.getSubId() != null : !this._subId.equals(other.getSubId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SubsImpl otherImpl = (SubsImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Subs>>, Augmentation<Subs>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Subs [");
            boolean first = true;
            if (this._gates != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_gates=");
                builder.append(this._gates);
            }
            if (this._key != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_key=");
                builder.append(this._key);
            }
            if (this._subId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subId=");
                builder.append(this._subId);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

