/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TosByte;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpProtocol;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.ext.classifier.ExtClassifier;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExtClassifierBuilder
implements Builder<ExtClassifier> {
    private Ipv4Address _dstIp;
    private Ipv4Address _dstIpMask;
    private PortNumber _dstPortEnd;
    private PortNumber _dstPortStart;
    private TpProtocol _protocol;
    private Ipv4Address _srcIp;
    private Ipv4Address _srcIpMask;
    private PortNumber _srcPortEnd;
    private PortNumber _srcPortStart;
    private TosByte _tosByte;
    private TosByte _tosMask;
    Map<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>> augmentation = Collections.emptyMap();

    public ExtClassifierBuilder() {
    }

    public ExtClassifierBuilder(TpPortMatchRanges arg) {
        this._srcPortStart = arg.getSrcPortStart();
        this._srcPortEnd = arg.getSrcPortEnd();
        this._dstPortStart = arg.getDstPortStart();
        this._dstPortEnd = arg.getDstPortEnd();
    }

    public ExtClassifierBuilder(ExtClassifier base) {
        AugmentationHolder casted;
        this._dstIp = base.getDstIp();
        this._dstIpMask = base.getDstIpMask();
        this._dstPortEnd = base.getDstPortEnd();
        this._dstPortStart = base.getDstPortStart();
        this._protocol = base.getProtocol();
        this._srcIp = base.getSrcIp();
        this._srcIpMask = base.getSrcIpMask();
        this._srcPortEnd = base.getSrcPortEnd();
        this._srcPortStart = base.getSrcPortStart();
        this._tosByte = base.getTosByte();
        this._tosMask = base.getTosMask();
        if (base instanceof ExtClassifierImpl) {
            ExtClassifierImpl impl = (ExtClassifierImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpPortMatchRanges) {
            this._srcPortStart = ((TpPortMatchRanges)arg).getSrcPortStart();
            this._srcPortEnd = ((TpPortMatchRanges)arg).getSrcPortEnd();
            this._dstPortStart = ((TpPortMatchRanges)arg).getDstPortStart();
            this._dstPortEnd = ((TpPortMatchRanges)arg).getDstPortEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.TpPortMatchRanges] \nbut was: " + arg);
        }
    }

    public Ipv4Address getDstIp() {
        return this._dstIp;
    }

    public Ipv4Address getDstIpMask() {
        return this._dstIpMask;
    }

    public PortNumber getDstPortEnd() {
        return this._dstPortEnd;
    }

    public PortNumber getDstPortStart() {
        return this._dstPortStart;
    }

    public TpProtocol getProtocol() {
        return this._protocol;
    }

    public Ipv4Address getSrcIp() {
        return this._srcIp;
    }

    public Ipv4Address getSrcIpMask() {
        return this._srcIpMask;
    }

    public PortNumber getSrcPortEnd() {
        return this._srcPortEnd;
    }

    public PortNumber getSrcPortStart() {
        return this._srcPortStart;
    }

    public TosByte getTosByte() {
        return this._tosByte;
    }

    public TosByte getTosMask() {
        return this._tosMask;
    }

    public <E extends Augmentation<ExtClassifier>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ExtClassifierBuilder setDstIp(Ipv4Address value) {
        if (value != null) {
            // empty if block
        }
        this._dstIp = value;
        return this;
    }

    public ExtClassifierBuilder setDstIpMask(Ipv4Address value) {
        if (value != null) {
            // empty if block
        }
        this._dstIpMask = value;
        return this;
    }

    private static void checkDstPortEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ExtClassifierBuilder setDstPortEnd(PortNumber value) {
        if (value != null) {
            ExtClassifierBuilder.checkDstPortEndRange(value.getValue());
        }
        this._dstPortEnd = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dstPortEnd_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkDstPortStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ExtClassifierBuilder setDstPortStart(PortNumber value) {
        if (value != null) {
            ExtClassifierBuilder.checkDstPortStartRange(value.getValue());
        }
        this._dstPortStart = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _dstPortStart_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkProtocolRange(int value) {
        if (value >= 0 && value <= 257) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025257]].", value));
    }

    public ExtClassifierBuilder setProtocol(TpProtocol value) {
        if (value != null) {
            ExtClassifierBuilder.checkProtocolRange(value.getValue());
        }
        this._protocol = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _protocol_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(257L)));
        return ret;
    }

    public ExtClassifierBuilder setSrcIp(Ipv4Address value) {
        if (value != null) {
            // empty if block
        }
        this._srcIp = value;
        return this;
    }

    public ExtClassifierBuilder setSrcIpMask(Ipv4Address value) {
        if (value != null) {
            // empty if block
        }
        this._srcIpMask = value;
        return this;
    }

    private static void checkSrcPortEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ExtClassifierBuilder setSrcPortEnd(PortNumber value) {
        if (value != null) {
            ExtClassifierBuilder.checkSrcPortEndRange(value.getValue());
        }
        this._srcPortEnd = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _srcPortEnd_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkSrcPortStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ExtClassifierBuilder setSrcPortStart(PortNumber value) {
        if (value != null) {
            ExtClassifierBuilder.checkSrcPortStartRange(value.getValue());
        }
        this._srcPortStart = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _srcPortStart_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(65535L)));
        return ret;
    }

    private static void checkTosByteRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public ExtClassifierBuilder setTosByte(TosByte value) {
        if (value != null) {
            ExtClassifierBuilder.checkTosByteRange(value.getValue());
        }
        this._tosByte = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tosByte_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    private static void checkTosMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public ExtClassifierBuilder setTosMask(TosByte value) {
        if (value != null) {
            ExtClassifierBuilder.checkTosMaskRange(value.getValue());
        }
        this._tosMask = value;
        return this;
    }

    @Deprecated
    public static List<Range<BigInteger>> _tosMask_range() {
        ArrayList<Range<BigInteger>> ret = new ArrayList<Range<BigInteger>>(1);
        ret.add(Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
        return ret;
    }

    public ExtClassifierBuilder addAugmentation(Class<? extends Augmentation<ExtClassifier>> augmentationType, Augmentation<ExtClassifier> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ExtClassifierBuilder removeAugmentation(Class<? extends Augmentation<ExtClassifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ExtClassifier build() {
        return new ExtClassifierImpl(this);
    }

    private static final class ExtClassifierImpl
    implements ExtClassifier {
        private final Ipv4Address _dstIp;
        private final Ipv4Address _dstIpMask;
        private final PortNumber _dstPortEnd;
        private final PortNumber _dstPortStart;
        private final TpProtocol _protocol;
        private final Ipv4Address _srcIp;
        private final Ipv4Address _srcIpMask;
        private final PortNumber _srcPortEnd;
        private final PortNumber _srcPortStart;
        private final TosByte _tosByte;
        private final TosByte _tosMask;
        private Map<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ExtClassifier> getImplementedInterface() {
            return ExtClassifier.class;
        }

        private ExtClassifierImpl(ExtClassifierBuilder base) {
            this._dstIp = base.getDstIp();
            this._dstIpMask = base.getDstIpMask();
            this._dstPortEnd = base.getDstPortEnd();
            this._dstPortStart = base.getDstPortStart();
            this._protocol = base.getProtocol();
            this._srcIp = base.getSrcIp();
            this._srcIpMask = base.getSrcIpMask();
            this._srcPortEnd = base.getSrcPortEnd();
            this._srcPortStart = base.getSrcPortStart();
            this._tosByte = base.getTosByte();
            this._tosMask = base.getTosMask();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getDstIp() {
            return this._dstIp;
        }

        @Override
        public Ipv4Address getDstIpMask() {
            return this._dstIpMask;
        }

        @Override
        public PortNumber getDstPortEnd() {
            return this._dstPortEnd;
        }

        @Override
        public PortNumber getDstPortStart() {
            return this._dstPortStart;
        }

        @Override
        public TpProtocol getProtocol() {
            return this._protocol;
        }

        @Override
        public Ipv4Address getSrcIp() {
            return this._srcIp;
        }

        @Override
        public Ipv4Address getSrcIpMask() {
            return this._srcIpMask;
        }

        @Override
        public PortNumber getSrcPortEnd() {
            return this._srcPortEnd;
        }

        @Override
        public PortNumber getSrcPortStart() {
            return this._srcPortStart;
        }

        @Override
        public TosByte getTosByte() {
            return this._tosByte;
        }

        @Override
        public TosByte getTosMask() {
            return this._tosMask;
        }

        public <E extends Augmentation<ExtClassifier>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dstIp == null ? 0 : this._dstIp.hashCode());
            result = 31 * result + (this._dstIpMask == null ? 0 : this._dstIpMask.hashCode());
            result = 31 * result + (this._dstPortEnd == null ? 0 : this._dstPortEnd.hashCode());
            result = 31 * result + (this._dstPortStart == null ? 0 : this._dstPortStart.hashCode());
            result = 31 * result + (this._protocol == null ? 0 : this._protocol.hashCode());
            result = 31 * result + (this._srcIp == null ? 0 : this._srcIp.hashCode());
            result = 31 * result + (this._srcIpMask == null ? 0 : this._srcIpMask.hashCode());
            result = 31 * result + (this._srcPortEnd == null ? 0 : this._srcPortEnd.hashCode());
            result = 31 * result + (this._srcPortStart == null ? 0 : this._srcPortStart.hashCode());
            result = 31 * result + (this._tosByte == null ? 0 : this._tosByte.hashCode());
            result = 31 * result + (this._tosMask == null ? 0 : this._tosMask.hashCode());
            this.hash = result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ExtClassifier.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ExtClassifier other = (ExtClassifier)obj;
            if (this._dstIp == null ? other.getDstIp() != null : !this._dstIp.equals((Object)other.getDstIp())) {
                return false;
            }
            if (this._dstIpMask == null ? other.getDstIpMask() != null : !this._dstIpMask.equals((Object)other.getDstIpMask())) {
                return false;
            }
            if (this._dstPortEnd == null ? other.getDstPortEnd() != null : !this._dstPortEnd.equals((Object)other.getDstPortEnd())) {
                return false;
            }
            if (this._dstPortStart == null ? other.getDstPortStart() != null : !this._dstPortStart.equals((Object)other.getDstPortStart())) {
                return false;
            }
            if (this._protocol == null ? other.getProtocol() != null : !this._protocol.equals(other.getProtocol())) {
                return false;
            }
            if (this._srcIp == null ? other.getSrcIp() != null : !this._srcIp.equals((Object)other.getSrcIp())) {
                return false;
            }
            if (this._srcIpMask == null ? other.getSrcIpMask() != null : !this._srcIpMask.equals((Object)other.getSrcIpMask())) {
                return false;
            }
            if (this._srcPortEnd == null ? other.getSrcPortEnd() != null : !this._srcPortEnd.equals((Object)other.getSrcPortEnd())) {
                return false;
            }
            if (this._srcPortStart == null ? other.getSrcPortStart() != null : !this._srcPortStart.equals((Object)other.getSrcPortStart())) {
                return false;
            }
            if (this._tosByte == null ? other.getTosByte() != null : !this._tosByte.equals(other.getTosByte())) {
                return false;
            }
            if (this._tosMask == null ? other.getTosMask() != null : !this._tosMask.equals(other.getTosMask())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ExtClassifierImpl otherImpl = (ExtClassifierImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ExtClassifier>>, Augmentation<ExtClassifier>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ExtClassifier [");
            boolean first = true;
            if (this._dstIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIp=");
                builder.append(this._dstIp);
            }
            if (this._dstIpMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstIpMask=");
                builder.append(this._dstIpMask);
            }
            if (this._dstPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortEnd=");
                builder.append(this._dstPortEnd);
            }
            if (this._dstPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstPortStart=");
                builder.append(this._dstPortStart);
            }
            if (this._protocol != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protocol=");
                builder.append(this._protocol);
            }
            if (this._srcIp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIp=");
                builder.append(this._srcIp);
            }
            if (this._srcIpMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcIpMask=");
                builder.append(this._srcIpMask);
            }
            if (this._srcPortEnd != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortEnd=");
                builder.append(this._srcPortEnd);
            }
            if (this._srcPortStart != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcPortStart=");
                builder.append(this._srcPortStart);
            }
            if (this._tosByte != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosByte=");
                builder.append(this._tosByte);
            }
            if (this._tosMask != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_tosMask=");
                builder.append(this._tosMask);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

