package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.PcmmQosGateAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.Subs;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * list gates {
 *     key "gateId"
 *     leaf gateId {
 *         type string;
 *     }
 *     container gate-spec {
 *         leaf direction {
 *             type service-flow-direction;
 *         }
 *         leaf dscp-tos-overwrite {
 *             type tos-byte;
 *         }
 *         leaf dscp-tos-mask {
 *             type tos-byte;
 *         }
 *     }
 *     container classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort {
 *             type port-number;
 *         }
 *         leaf dstPort {
 *             type port-number;
 *         }
 *     }
 *     container ipv6-classifier {
 *         leaf srcIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf dstIp6 {
 *             type ipv6-prefix;
 *         }
 *         leaf tc-low {
 *             type tos-byte;
 *         }
 *         leaf tc-high {
 *             type tos-byte;
 *         }
 *         leaf tc-mask {
 *             type tos-byte;
 *         }
 *         leaf next-hdr {
 *             type tp-protocol;
 *         }
 *         leaf flow-label {
 *             type uint32;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 *     container traffic-profile {
 *         leaf service-class-name {
 *             type service-class-name;
 *         }
 *     }
 *     container ext-classifier {
 *         leaf srcIp {
 *             type ipv4-address;
 *         }
 *         leaf srcIpMask {
 *             type ipv4-address;
 *         }
 *         leaf dstIp {
 *             type ipv4-address;
 *         }
 *         leaf dstIpMask {
 *             type ipv4-address;
 *         }
 *         leaf tos-byte {
 *             type tos-byte;
 *         }
 *         leaf tos-mask {
 *             type tos-byte;
 *         }
 *         leaf protocol {
 *             type tp-protocol;
 *         }
 *         leaf srcPort-start {
 *             type port-number;
 *         }
 *         leaf srcPort-end {
 *             type port-number;
 *         }
 *         leaf dstPort-start {
 *             type port-number;
 *         }
 *         leaf dstPort-end {
 *             type port-number;
 *         }
 *         uses tp-port-match-ranges;
 *     }
 *     uses pcmm-qos-gate-attributes;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-gates/apps/subs/gates&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesBuilder
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.GatesKey
 *
 */
public interface Gates
    extends
    ChildOf<Subs>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates>,
    PcmmQosGateAttributes,
    Identifiable<GatesKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","gates"));

    /**
     * Qos Gate Identity
     *
     */
    java.lang.String getGateId();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     */
    GatesKey getKey();

}

