package org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.Apps;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.subs.Gates;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import java.util.List;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;packetcable&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/packetcable.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * list subs {
 *     key "subId"
 *     leaf subId {
 *         type string;
 *     }
 *     list gates {
 *         key "gateId"
 *         leaf gateId {
 *             type string;
 *         }
 *         container gate-spec {
 *             leaf direction {
 *                 type service-flow-direction;
 *             }
 *             leaf dscp-tos-overwrite {
 *                 type tos-byte;
 *             }
 *             leaf dscp-tos-mask {
 *                 type tos-byte;
 *             }
 *         }
 *         container classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort {
 *                 type port-number;
 *             }
 *             leaf dstPort {
 *                 type port-number;
 *             }
 *         }
 *         container ipv6-classifier {
 *             leaf srcIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf dstIp6 {
 *                 type ipv6-prefix;
 *             }
 *             leaf tc-low {
 *                 type tos-byte;
 *             }
 *             leaf tc-high {
 *                 type tos-byte;
 *             }
 *             leaf tc-mask {
 *                 type tos-byte;
 *             }
 *             leaf next-hdr {
 *                 type tp-protocol;
 *             }
 *             leaf flow-label {
 *                 type uint32;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *         container traffic-profile {
 *             leaf service-class-name {
 *                 type service-class-name;
 *             }
 *         }
 *         container ext-classifier {
 *             leaf srcIp {
 *                 type ipv4-address;
 *             }
 *             leaf srcIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf dstIp {
 *                 type ipv4-address;
 *             }
 *             leaf dstIpMask {
 *                 type ipv4-address;
 *             }
 *             leaf tos-byte {
 *                 type tos-byte;
 *             }
 *             leaf tos-mask {
 *                 type tos-byte;
 *             }
 *             leaf protocol {
 *                 type tp-protocol;
 *             }
 *             leaf srcPort-start {
 *                 type port-number;
 *             }
 *             leaf srcPort-end {
 *                 type port-number;
 *             }
 *             leaf dstPort-start {
 *                 type port-number;
 *             }
 *             leaf dstPort-end {
 *                 type port-number;
 *             }
 *             uses tp-port-match-ranges;
 *         }
 *         uses pcmm-qos-gate-attributes;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;packetcable/pcmm-qos-gates/apps/subs&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.SubsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.SubsBuilder
 * @see org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.SubsKey
 *
 */
public interface Subs
    extends
    ChildOf<Apps>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.packetcable.rev150327.pcmm.qos.gates.apps.Subs>,
    Identifiable<SubsKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:packetcable","2015-03-27","subs"));

    /**
     * Subscriber Identity -- must be a CM or CPE IP address
     *
     */
    java.lang.String getSubId();
    
    List<Gates> getGates();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     */
    SubsKey getKey();

}

